/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.eventconf.PathType;
import org.opennms.integration.api.xml.schema.eventconf.PathTypeAdapter;
import org.opennms.integration.api.xml.schema.eventconf.StateType;

@XmlRootElement(name="correlation")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Correlation
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="state")
    private StateType m_state;
    @XmlAttribute(name="path")
    @XmlJavaTypeAdapter(value=PathTypeAdapter.class)
    private PathType m_path;
    @XmlElement(name="cuei")
    private List<String> m_cueis = new ArrayList<String>();
    @XmlElement(name="cmin")
    private String m_cmin;
    @XmlElement(name="cmax")
    private String m_cmax;
    @XmlElement(name="ctime")
    private String m_ctime;

    public StateType getState() {
        return this.m_state == null ? StateType.OFF : this.m_state;
    }

    public void setState(StateType state) {
        this.m_state = state;
    }

    public PathType getPath() {
        return this.m_path == null ? PathType.SUPPRESS_DUPLICATES : this.m_path;
    }

    public void setPath(PathType path) {
        this.m_path = path;
    }

    public List<String> getCueis() {
        return this.m_cueis;
    }

    public void setCueis(List<String> cueis) {
        if (cueis == this.m_cueis) {
            return;
        }
        this.m_cueis.clear();
        for (String cuei : cueis) {
            this.m_cueis.add(cuei.intern());
        }
    }

    public void addCuei(String cuei) {
        this.m_cueis.add(ConfigUtils.normalizeAndInternString(cuei));
    }

    public boolean removeCuei(String cuei) {
        return this.m_cueis.remove(cuei);
    }

    public String getCmin() {
        return this.m_cmin;
    }

    public void setCmin(String cmin) {
        this.m_cmin = ConfigUtils.normalizeAndInternString(cmin);
    }

    public String getCmax() {
        return this.m_cmax;
    }

    public void setCmax(String cmax) {
        this.m_cmax = ConfigUtils.normalizeAndInternString(cmax);
    }

    public String getCtime() {
        return this.m_ctime;
    }

    public void setCtime(String ctime) {
        this.m_ctime = ConfigUtils.normalizeAndInternString(ctime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_state, this.m_path, this.m_cueis, this.m_cmin, this.m_cmax, this.m_ctime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Correlation) {
            Correlation that = (Correlation)obj;
            return Objects.equals((Object)this.m_state, (Object)that.m_state) && Objects.equals((Object)this.m_path, (Object)that.m_path) && Objects.equals(this.m_cueis, that.m_cueis) && Objects.equals(this.m_cmin, that.m_cmin) && Objects.equals(this.m_cmax, that.m_cmax) && Objects.equals(this.m_ctime, that.m_ctime);
        }
        return false;
    }
}

