/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceType {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceType.class);
    private SnmpCollectionAgent m_agent;
    private OnmsSnmpCollection m_snmpCollection;
    private Collection<SnmpAttributeType> m_attributeTypes;

    public ResourceType(SnmpCollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public SnmpCollectionAgent getAgent() {
        return this.m_agent;
    }

    protected String getCollectionName() {
        return this.m_snmpCollection.getName();
    }

    protected OnmsSnmpCollection getCollection() {
        return this.m_snmpCollection;
    }

    public final Collection<SnmpAttributeType> getAttributeTypes() {
        if (this.m_attributeTypes == null) {
            this.m_attributeTypes = this.loadAttributeTypes();
        }
        return this.m_attributeTypes;
    }

    protected abstract Collection<SnmpAttributeType> loadAttributeTypes();

    protected boolean hasDataToCollect() {
        return !this.getAttributeTypes().isEmpty();
    }

    public SnmpInstId[] getCollectionInstances() {
        return null;
    }

    public abstract SnmpCollectionResource findResource(SnmpInstId var1);

    public abstract SnmpCollectionResource findAliasedResource(SnmpInstId var1, String var2);

    public abstract Collection<? extends SnmpCollectionResource> getResources();
}

