/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ExpressionThresholdValueSupplier;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdValuesSupplier;
import org.opennms.netmgt.threshd.api.ReinitializableState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;

public interface ThresholdEvaluatorState
extends ReinitializableState {
    default public Status evaluate(double dsValue) {
        return this.evaluate(dsValue, null);
    }

    public Status evaluate(double var1, Long var3);

    public Status evaluate(double var1, ThresholdValues var3, Long var4);

    public ValueStatus evaluate(ExpressionThresholdValueSupplier var1, Long var2) throws ThresholdExpressionException;

    public ValueStatus evaluate(ThresholdValuesSupplier var1, Long var2) throws ThresholdExpressionException;

    public Event getEventForState(Status var1, Date var2, double var3, ThresholdValues var5, CollectionResourceWrapper var6);

    public boolean isTriggered();

    public void clearState();

    public BaseThresholdDefConfigWrapper getThresholdConfig();

    public ThresholdEvaluatorState getCleanClone();

    public ThresholdingSession getThresholdingSession();

    public void setInstance(String var1);

    public static enum Status {
        NO_CHANGE,
        TRIGGERED,
        RE_ARMED;

    }

    public static class ThresholdValues
    implements Serializable {
        private static final long serialVersionUID = -788891453989005407L;
        private final Double threshold;
        private final Double rearm;
        private final Integer trigger;
        private Double dsValue;

        public ThresholdValues(Double threshold, Double rearm, Integer trigger) {
            this.threshold = threshold;
            this.rearm = rearm;
            this.trigger = trigger;
        }

        public Double getThresholdValue() {
            return this.threshold;
        }

        public Double getRearm() {
            return this.rearm;
        }

        public Integer getTrigger() {
            return this.trigger;
        }

        public Double getDsValue() {
            return this.dsValue;
        }

        public void setDsValue(Double dsValue) {
            this.dsValue = dsValue;
        }
    }

    public static class ValueStatus {
        public final double value;
        public final Status status;
        public final ThresholdValues thresholdValues;

        public ValueStatus(double value, Status status, ThresholdValues thresholdValues) {
            this.value = value;
            this.status = Objects.requireNonNull(status);
            this.thresholdValues = thresholdValues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueStatus that = (ValueStatus)o;
            return Double.compare(that.value, this.value) == 0 && this.status == that.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.status});
        }

        public String toString() {
            return "ValueStatus{value=" + this.value + ", status=" + String.valueOf((Object)this.status) + "}";
        }
    }
}

