/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThresholdEvaluatorAbsoluteChange
implements ThresholdEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdEvaluatorAbsoluteChange.class);
    private static final ThresholdType TYPE = ThresholdType.ABSOLUTE_CHANGE;

    @Override
    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
        return new ThresholdEvaluatorStateAbsoluteChange(threshold, thresholdingSession);
    }

    @Override
    public boolean supportsType(ThresholdType type) {
        return TYPE.equals((Object)type);
    }

    public static class ThresholdEvaluatorStateAbsoluteChange
    extends AbstractThresholdEvaluatorState<State> {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;

        public ThresholdEvaluatorStateAbsoluteChange(BaseThresholdDefConfigWrapper threshold, ThresholdingSession thresholdingSession) {
            super(threshold, thresholdingSession, State.class);
            this.setThresholdConfig(threshold);
        }

        @Override
        protected void initializeState() {
            this.state = new State();
        }

        private void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)TYPE.equals((Object)thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + String.valueOf(thresholdConfig.getType()) + "', but this evaluator only supports thresholds with a 'type' value of '" + String.valueOf(TYPE) + "'"));
            this.m_thresholdConfig = thresholdConfig;
        }

        @Override
        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        @Override
        public ThresholdEvaluatorState.Status evaluateAfterFetch(double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues) {
            if (!Double.isNaN(this.getLastSample())) {
                Double change;
                Double d = change = thresholdValues != null && thresholdValues.getThresholdValue() != null ? thresholdValues.getThresholdValue() : this.m_thresholdConfig.getValue();
                if (change == null) {
                    return ThresholdEvaluatorState.Status.NO_CHANGE;
                }
                double threshold = this.getLastSample() + change;
                if (change < 0.0) {
                    if (dsValue <= threshold) {
                        this.setPreviousTriggeringSample(this.getLastSample());
                        this.setLastSample(dsValue);
                        LOG.debug("evaluate: absolute negative change threshold triggered");
                        return ThresholdEvaluatorState.Status.TRIGGERED;
                    }
                } else if (dsValue >= threshold) {
                    this.setPreviousTriggeringSample(this.getLastSample());
                    this.setLastSample(dsValue);
                    LOG.debug("evaluate: absolute positive change threshold triggered");
                    return ThresholdEvaluatorState.Status.TRIGGERED;
                }
            }
            this.setLastSample(dsValue);
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        private Double getLastSample() {
            return ((State)this.state).m_lastSample;
        }

        private void setLastSample(double lastSample) {
            if (lastSample != ((State)this.state).m_lastSample) {
                ((State)this.state).m_lastSample = lastSample;
                this.markDirty();
            }
        }

        @Override
        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues, CollectionResourceWrapper resource) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI().orElse("uei.opennms.org/threshold/absoluteChangeExceeded");
                return this.createBasicEvent(uei, date, dsValue, thresholdValues, resource);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, ThresholdEvaluatorState.ThresholdValues thresholdValues, CollectionResourceWrapper resource) {
            if (thresholdValues == null) {
                thresholdValues = ((State)this.state).getThresholdValues();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("previousValue", this.formatValue(this.getPreviousTriggeringSample()));
            params.put("changeThreshold", Double.toString(thresholdValues.getThresholdValue()));
            params.put("trigger", Integer.toString(thresholdValues.getTrigger()));
            return this.createBasicEvent(uei, date, dsValue, resource, params);
        }

        private double getPreviousTriggeringSample() {
            return ((State)this.state).m_previousTriggeringSample;
        }

        private void setPreviousTriggeringSample(double previousTriggeringSample) {
            if (((State)this.state).m_previousTriggeringSample != previousTriggeringSample) {
                ((State)this.state).m_previousTriggeringSample = previousTriggeringSample;
                this.markDirty();
            }
        }

        @Override
        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateAbsoluteChange(this.m_thresholdConfig, this.getThresholdingSession());
        }

        @Override
        public boolean isTriggered() {
            return false;
        }

        @Override
        public void clearStateBeforePersist() {
            this.initializeState();
        }

        static class State
        extends AbstractThresholdEvaluatorState.AbstractState {
            private static final long serialVersionUID = 1L;
            private double m_lastSample = Double.NaN;
            private double m_previousTriggeringSample;

            State() {
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("lastSample=").append(this.m_lastSample);
                sb.append("\npreviousTriggeringSample=").append(this.m_previousTriggeringSample);
                String superString = super.toString();
                if (superString != null) {
                    sb.append("\n").append(superString);
                }
                return sb.toString();
            }
        }
    }
}

