/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.Scope;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;

public class SecureCredentialsVaultScope
implements Scope {
    public static final String CONTEXT = "scv";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private final SecureCredentialsVault scv;

    public SecureCredentialsVaultScope(SecureCredentialsVault scv) {
        this.scv = Objects.requireNonNull(scv);
    }

    @Override
    public Optional<Scope.ScopeValue> get(ContextKey contextKey) {
        if (!CONTEXT.equals(contextKey.context)) {
            return Optional.empty();
        }
        int split = contextKey.key.indexOf(58);
        if (split == -1) {
            return Optional.empty();
        }
        String alias = contextKey.key.substring(0, split);
        String attr = contextKey.key.substring(split + 1);
        if (Strings.isNullOrEmpty((String)alias) || Strings.isNullOrEmpty((String)attr)) {
            return Optional.empty();
        }
        Credentials cred = this.scv.getCredentials(alias);
        if (cred == null) {
            return Optional.empty();
        }
        String value = USERNAME.equals(attr) ? cred.getUsername() : (PASSWORD.equals(attr) ? cred.getPassword() : cred.getAttribute(attr));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new Scope.ScopeValue(Scope.ScopeName.GLOBAL, value));
    }

    @Override
    public Set<ContextKey> keys() {
        return this.scv.getAliases().stream().flatMap(alias -> Stream.concat(Stream.of(USERNAME, PASSWORD), this.scv.getCredentials(alias).getAttributeKeys().stream()).map(attr -> new ContextKey(CONTEXT, String.format("%s:%s", alias, attr)))).collect(Collectors.toSet());
    }
}

