/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opennms.core.mate.api.ContextKey;

public interface Scope {
    public Optional<ScopeValue> get(ContextKey var1);

    public Set<ContextKey> keys();

    public static enum ScopeName {
        DEFAULT,
        GLOBAL,
        NODE,
        INTERFACE,
        SERVICE;

    }

    public static class ScopeValue {
        public final ScopeName scopeName;
        public final String value;

        public ScopeValue(ScopeName scopeName, String value) {
            this.scopeName = Objects.requireNonNull(scopeName);
            this.value = Objects.requireNonNull(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScopeValue that = (ScopeValue)o;
            return this.scopeName == that.scopeName && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scopeName, this.value});
        }

        public String toString() {
            return "ScopeValue{scopeName=" + String.valueOf((Object)this.scopeName) + ", value='" + this.value + "'}";
        }
    }
}

