/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.impl;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.vavr.control.Either;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.concurrent.FutureUtils;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.HealthCheckService;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthCheckService
implements HealthCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHealthCheckService.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("health-check-%d").build());
    private BundleContext bundleContext;

    public DefaultHealthCheckService(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    protected List<HealthCheck> getHealthChecks() throws InvalidSyntaxException {
        Collection serviceReferences = this.bundleContext.getServiceReferences(HealthCheck.class, null);
        return serviceReferences.stream().sorted(Comparator.comparingLong(ref -> ref.getBundle().getBundleId())).map(ref -> (HealthCheck)this.bundleContext.getService(ref)).collect(Collectors.toList());
    }

    public Either<String, CompletionStage<Health>> performAsyncHealthCheck(Context context, HealthCheckService.ProgressListener listener, List<String> tags) {
        try {
            List<HealthCheck> checks = this.getHealthChecks();
            checks = this.filterChecksWithTags(checks, tags);
            if (checks == null || checks.isEmpty()) {
                return Either.left((Object)"No Health Checks available");
            }
            if (listener != null) {
                listener.onHealthChecksFound(checks);
            }
            return Either.right(this.runChecks(context, checks, listener));
        }
        catch (InvalidSyntaxException ex) {
            return Either.left((Object)("Error while performing health checks: " + ex.getMessage()));
        }
    }

    List<HealthCheck> filterChecksWithTags(List<HealthCheck> checks, List<String> tags) {
        if (checks != null && tags != null && tags.stream().anyMatch(tag -> !Strings.isNullOrEmpty((String)tag))) {
            checks = checks.stream().filter(check -> check.getTags().stream().anyMatch(tags::contains)).collect(Collectors.toList());
        }
        return checks;
    }

    private CompletionStage<Pair<HealthCheck, Response>> completionStage(HealthCheck check, Context context, HealthCheckService.ProgressListener listener) {
        return FutureUtils.completionStageWithDefaultOnTimeout(() -> {
            try {
                Response response;
                if (listener != null) {
                    listener.onPerform(check);
                }
                return (response = check.perform(context)) != null ? response : Response.UNKNOWN;
            }
            catch (Throwable t) {
                return new Response(t);
            }
        }, (Duration)Duration.ofMillis(context.getTimeout()), () -> new Response(Status.Timeout, "Health Check did not finish within " + context.getTimeout() + " ms"), (ExecutorService)this.executorService).thenApply(response -> {
            if (listener != null) {
                listener.onResponse(check, response);
            }
            return Pair.of((Object)check, (Object)response);
        });
    }

    private CompletionStage<Health> runChecks(Context context, List<HealthCheck> checks, HealthCheckService.ProgressListener listener) {
        return FutureUtils.traverse(checks, check -> this.completionStage((HealthCheck)check, context, listener)).thenApply(list -> {
            Health health = new Health(list);
            if (listener != null) {
                listener.onAllHealthChecksCompleted(health);
            }
            return health;
        });
    }
}

