/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi;

import java.util.Arrays;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ServletEvent {
    public static final int DEPLOYING = 1;
    public static final int DEPLOYED = 2;
    public static final int UNDEPLOYING = 3;
    public static final int UNDEPLOYED = 4;
    public static final int FAILED = 5;
    public static final int WAITING = 6;
    private final boolean replay;
    private final int type;
    private final Bundle bundle;
    private final long bundleId;
    private final String bundleName;
    private final long timestamp;
    private final String alias;
    private final String servletName;
    private final String[] urlParameter;
    private final Servlet servlet;
    private final String servletClassName;
    private final HttpContext httpContext;
    private final String bundleVersion;

    public ServletEvent(ServletEvent event, boolean replay) {
        this.type = event.getType();
        this.bundle = event.getBundle();
        this.bundleId = event.getBundleId();
        this.bundleName = event.getBundleName();
        this.bundleVersion = event.getBundleVersion();
        this.alias = event.getAlias();
        this.servletName = event.getServletName();
        this.urlParameter = event.getUrlParameter();
        this.servlet = event.getServlet();
        this.servletClassName = event.getServletClassName();
        this.timestamp = event.getTimestamp();
        this.httpContext = event.getHttpContext();
        this.replay = replay;
    }

    public ServletEvent(int type, Bundle bundle, String alias, String servletName, String[] urlParameter, Servlet servlet, Class<? extends Servlet> servletClass, HttpContext httpContext) {
        this.type = type;
        this.bundle = bundle;
        this.bundleId = bundle.getBundleId();
        this.bundleName = bundle.getSymbolicName();
        this.bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
        this.alias = alias;
        this.servletName = servletName;
        this.urlParameter = urlParameter != null ? Arrays.copyOf(urlParameter, urlParameter.length) : null;
        this.servlet = servlet;
        this.servletClassName = servletClass.getCanonicalName();
        this.httpContext = httpContext;
        this.timestamp = System.currentTimeMillis();
        this.replay = false;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public int getType() {
        return this.type;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String[] getUrlParameter() {
        return this.urlParameter;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public String toString() {
        return "ServletEvent [replay=" + this.replay + ", type=" + this.type(this.type) + ", bundle=" + this.bundleId + "-" + this.bundleName + ", timestamp=" + this.timestamp + ", alias=" + this.alias + ", servletName=" + this.servletName + ", urlParameter=" + (this.urlParameter == null ? "null" : Arrays.asList(this.urlParameter)) + ", servletClass=" + this.servletClassName + "], httpContext=" + this.httpContext + "]";
    }

    private String type(int type) {
        String name = "UNKNOWN";
        switch (type) {
            case 1: {
                name = "DEPLOYING";
                break;
            }
            case 2: {
                name = "DEPLOYED";
                break;
            }
            case 3: {
                name = "UNDEPLOYING";
                break;
            }
            case 4: {
                name = "UNDEPLOYED";
                break;
            }
            case 5: {
                name = "FAILED";
                break;
            }
            case 6: {
                name = "WAITING";
            }
        }
        return name;
    }
}

