/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.scheduler.Executable;
import org.opennms.netmgt.scheduler.LegacyPriorityExecutor;
import org.opennms.netmgt.scheduler.Schedulable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SchedulableExecutableGroup
extends Schedulable {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulableExecutableGroup.class);
    private final Set<Executable> m_executables = new HashSet<Executable>();
    private final LegacyPriorityExecutor m_executor;
    private final String m_name;

    public SchedulableExecutableGroup(long interval, long initial, LegacyPriorityExecutor executor, String name) {
        super(interval, initial);
        Assert.notNull((Object)executor);
        Assert.notNull((Object)name);
        this.m_executor = executor;
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public Set<Executable> getExecutables() {
        return this.m_executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Executable discovery) {
        Set<Executable> set = this.m_executables;
        synchronized (set) {
            if (this.m_executables.add(discovery)) {
                LOG.info("add: {}", (Object)discovery.getInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Executable discovery) {
        Set<Executable> set = this.m_executables;
        synchronized (set) {
            if (this.m_executables.remove(discovery)) {
                LOG.info("remove: {}", (Object)discovery.getInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<Executable> set = this.m_executables;
        synchronized (set) {
            this.m_executables.clear();
        }
    }

    @Override
    public void runSchedulable() {
        LOG.info("run: {}", (Object)this.m_name);
        this.m_executables.forEach(this.m_executor::addPriorityReadyRunnable);
    }
}

