/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.util;

import ch.hsr.geohash.WGS84Point;

public class VincentyGeodesy {
    static final double equatorRadius = 6378137.0;
    static final double poleRadius = 6356752.3142;
    static final double f = 0.0033528106647474805;
    public static final double degToRad = 0.0174532925199433;
    static final double equatorRadiusSquared = 4.0680631590769E13;
    static final double poleRadiusSquared = 4.0408299984087055E13;
    public static final double EPSILON = 1.0E-12;

    public static WGS84Point moveInDirection(WGS84Point point, double bearingInDegrees, double distanceInMeters) {
        if (bearingInDegrees < 0.0 || bearingInDegrees > 360.0) {
            throw new IllegalArgumentException("direction must be in (0,360)");
        }
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double alpha1 = bearingInDegrees * 0.0174532925199433;
        double sinAlpha1 = Math.sin(alpha1);
        double cosAlpha1 = Math.cos(alpha1);
        double tanU1 = (1.0 - f) * Math.tan(point.getLatitude() * 0.0174532925199433);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double sigma1 = Math.atan2(tanU1, cosAlpha1);
        double sinAlpha = cosU1 * sinAlpha1;
        double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double cos2SigmaM = 0.0;
        double sigma = distanceInMeters / (b * A);
        double sigmaP = Math.PI * 2;
        while (Math.abs(sigma - sigmaP) > 1.0E-12) {
            cos2SigmaM = Math.cos(2.0 * sigma1 + sigma);
            sinSigma = Math.sin(sigma);
            cosSigma = Math.cos(sigma);
            double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
            sigmaP = sigma;
            sigma = distanceInMeters / (b * A) + deltaSigma;
        }
        double tmp = sinU1 * sinSigma - cosU1 * cosSigma * cosAlpha1;
        double lat2 = Math.atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosAlpha1, (1.0 - f) * Math.sqrt(sinAlpha * sinAlpha + tmp * tmp));
        double lambda = Math.atan2(sinSigma * sinAlpha1, cosU1 * cosSigma - sinU1 * sinSigma * cosAlpha1);
        double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
        double L = lambda - (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        double newLat = lat2 / 0.0174532925199433;
        double newLon = point.getLongitude() + L / 0.0174532925199433;
        newLon = newLon > 180.0 ? newLon - 360.0 : newLon;
        newLon = newLon < -180.0 ? 360.0 + newLon : newLon;
        return new WGS84Point(newLat, newLon);
    }

    public static double distanceInMeters(WGS84Point foo, WGS84Point bar) {
        double lambdaP;
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double L = (bar.getLongitude() - foo.getLongitude()) * 0.0174532925199433;
        double U1 = Math.atan((1.0 - f) * Math.tan(foo.getLatitude() * 0.0174532925199433));
        double U2 = Math.atan((1.0 - f) * Math.tan(bar.getLatitude() * 0.0174532925199433));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 20.0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSquared = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
        double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double s = b * A * (sigma - deltaSigma);
        return s;
    }
}

