/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.support;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;

public abstract class AbstractServiceMonitor
implements ServiceMonitor {
    @Override
    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        return Collections.emptyMap();
    }

    @Override
    public String getEffectiveLocation(String location) {
        return location;
    }

    public static Object getKeyedObject(Map<String, Object> parameterMap, String key, Object defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object value = parameterMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T getKeyedInstance(Map<String, Object> parameterMap, String key, Supplier<T> defaultValue) {
        if (key == null) {
            return defaultValue.get();
        }
        Object value = parameterMap.get(key);
        if (value == null) {
            return defaultValue.get();
        }
        return (T)value;
    }

    public static Boolean getKeyedBoolean(Map<String, Object> parameterMap, String key, Boolean defaultValue) {
        Object value = AbstractServiceMonitor.getKeyedObject(parameterMap, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase((String)value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static String getKeyedString(Map<String, Object> parameterMap, String key, String defaultValue) {
        Object value = AbstractServiceMonitor.getKeyedObject(parameterMap, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Integer getKeyedInteger(Map<String, Object> parameterMap, String key, Integer defaultValue) {
        Object value = AbstractServiceMonitor.getKeyedObject(parameterMap, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public static Long getKeyedLong(Map<String, Object> parameterMap, String key, Long defaultValue) {
        Object value = AbstractServiceMonitor.getKeyedObject(parameterMap, key, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultValue;
    }

    public static Properties getServiceProperties(MonitoredService svc) {
        InetAddress addr = InetAddressUtils.addr((String)svc.getIpAddr());
        boolean requireBrackets = addr != null && addr instanceof Inet6Address && !svc.getIpAddr().startsWith("[");
        Properties properties = new Properties();
        properties.put("ipaddr", requireBrackets ? "[" + svc.getIpAddr() + "]" : svc.getIpAddr());
        properties.put("nodeid", (Object)svc.getNodeId());
        properties.put("nodelabel", svc.getNodeLabel());
        properties.put("svcname", svc.getSvcName());
        return properties;
    }
}

