/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.opennms.integration.api.sample.RequisitionTestContextManager;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.events.EventForwarder;
import org.opennms.integration.api.v1.events.EventListener;
import org.opennms.integration.api.v1.events.EventSubscriptionService;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.immutables.ImmutableEventParameter;
import org.opennms.integration.api.v1.model.immutables.ImmutableInMemoryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionHealthCheck.class);
    public static final String IMPORT_STARTED_UEI = "uei.opennms.org/internal/importer/importStarted";
    public static final String PARM_IMPORT_RESOURCE = "importResource";
    private final NodeDao nodeDao;
    private final EventForwarder eventForwarder;
    private final EventSubscriptionService eventSubscriptionService;
    private final RequisitionTestContextManager requisitionManager;

    public RequisitionHealthCheck(NodeDao nodeDao, EventForwarder eventForwarder, EventSubscriptionService eventSubscriptionService, RequisitionTestContextManager requisitionManager) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.requisitionManager = Objects.requireNonNull(requisitionManager);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: Requisition";
    }

    public Response perform(Context context) throws InterruptedException {
        try (RequisitionTestContextManager.RequisitionTestSession testSession = this.requisitionManager.newSession();){
            String foreignSource = "oia-test-requisition-" + testSession.getSessionId();
            List nodes = this.nodeDao.getNodesInForeignSource(foreignSource);
            if (!nodes.isEmpty()) {
                ImmutableResponse immutableResponse = ImmutableResponse.newInstance((Status)Status.Failure, (String)String.format("Expected to find 0 nodes in foreign-source %s, but found %d.", foreignSource, nodes.size()));
                return immutableResponse;
            }
            String url = String.format("requisition://%s?foreignSource=%s&sessionId=%s", "MyRequisitionProvider", foreignSource, testSession.getSessionId());
            try (EventHandler eventHandler = new EventHandler(this.eventSubscriptionService, testSession.getSessionId());){
                ImmutableInMemoryEvent reloadImport = ImmutableInMemoryEvent.newBuilder().setUei("uei.opennms.org/internal/importer/reloadImport").setSource(RequisitionHealthCheck.class.getCanonicalName()).addParameter((EventParameter)ImmutableEventParameter.newInstance((String)"url", (String)url)).build();
                this.eventForwarder.sendSync((InMemoryEvent)reloadImport);
                eventHandler.waitForImportStarted();
            }
            testSession.waitForGet();
        }
        return ImmutableResponse.newInstance((Status)Status.Success);
    }

    private static class EventHandler
    implements EventListener,
    AutoCloseable {
        private final EventSubscriptionService eventSubscriptionService;
        private final String sessionId;
        private CountDownLatch startedLatch = new CountDownLatch(1);

        public EventHandler(EventSubscriptionService eventSubscriptionService, String sessionId) {
            this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
            this.sessionId = Objects.requireNonNull(sessionId);
            eventSubscriptionService.addEventListener((EventListener)this, RequisitionHealthCheck.IMPORT_STARTED_UEI);
        }

        public String getName() {
            return EventHandler.class.getCanonicalName() + "-" + this.sessionId;
        }

        public int getNumThreads() {
            return 1;
        }

        public void onEvent(InMemoryEvent event) {
            if (event == null || !RequisitionHealthCheck.IMPORT_STARTED_UEI.equals(event.getUei())) {
                return;
            }
            String actualResource = event.getParameterValue(RequisitionHealthCheck.PARM_IMPORT_RESOURCE).orElse(null);
            if (actualResource == null) {
                LOG.warn("No import resource parameter found on import started event. Ignoring.");
                return;
            }
            if (actualResource.contains(this.sessionId)) {
                this.startedLatch.countDown();
            }
        }

        public void waitForImportStarted() throws InterruptedException {
            this.startedLatch.await();
        }

        @Override
        public void close() {
            this.eventSubscriptionService.removeEventListener((EventListener)this, RequisitionHealthCheck.IMPORT_STARTED_UEI);
        }
    }
}

