/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opennms.netmgt.config.api.PathOutageConfig;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;

public interface PollerConfig
extends PathOutageConfig {
    public String getCriticalService();

    public boolean shouldPollAllIfNoCriticalServiceDefined();

    public boolean isNodeOutageProcessingEnabled();

    public boolean isServiceUnresponsiveEnabled();

    public boolean isAsyncEngineEnabled();

    public int getMaxConcurrentAsyncPolls();

    public void rebuildPackageIpListMap();

    public Iterable<Parameter> parameters(Service var1);

    public List<InetAddress> getIpList(Package var1);

    public boolean isInterfaceInPackage(String var1, Package var2);

    public boolean isServiceInPackageAndEnabled(String var1, Package var2);

    public Service getServiceInPackage(String var1, Package var2);

    public boolean isServiceMonitored(String var1);

    public Package getFirstLocalPackageMatch(String var1);

    public boolean isPolled(String var1);

    public boolean isPolledLocally(String var1);

    public boolean isPolled(String var1, Package var2);

    public boolean isPolled(String var1, String var2);

    public boolean isPolledLocally(String var1, String var2);

    public int getStep(Package var1);

    public List<String> getRRAList(Package var1);

    public List<String> getAllPackageMatches(String var1);

    public String getNextOutageIdSql();

    public Enumeration<Package> enumeratePackage();

    public List<Package> getPackages();

    default public Package findPackageForService(String ipAddr, String serviceName) {
        Package lastPkg = null;
        for (Package pkg : this.getPackages()) {
            if (pkg.getPerspectiveOnly() || !this.isServiceInPackageAndEnabled(serviceName, pkg) || !this.isInterfaceInPackage(ipAddr, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    default public Optional<Package.ServiceMatch> findService(String ipAddr, String serviceName) {
        Package pkg = this.findPackageForService(ipAddr, serviceName);
        if (pkg == null) {
            return Optional.empty();
        }
        return pkg.findService(serviceName);
    }

    public Package getPackage(String var1);

    public int getThreads();

    public Set<String> getServiceMonitorNames();

    public Optional<ServiceMonitorLocator> getServiceMonitorLocator(String var1);

    public void update() throws IOException;

    public void save() throws IOException;

    public void addPackage(Package var1);

    public PollerConfiguration getLocalConfiguration();

    default public PollerConfiguration getExtendedConfiguration() {
        return this.getLocalConfiguration();
    }

    public Collection<ServiceMonitorLocator> getServiceMonitorLocators();

    public ServiceMonitorRegistry getServiceMonitorRegistry();

    public void setExternalData(List<Package> var1, List<Monitor> var2);

    public Lock getReadLock();

    public Lock getWriteLock();
}

