/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.resource;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.resource.ResourceDTOCollection;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceDTO {
    @XmlAttribute(name="id")
    private String m_id;
    @XmlAttribute(name="label")
    private String m_label;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="link")
    private String m_link;
    @XmlAttribute(name="typeLabel")
    private String m_typeLabel;
    @XmlAttribute(name="parentId")
    private String m_parentId;
    @XmlElement(name="children")
    private ResourceDTOCollection m_children;
    @XmlElementWrapper(name="stringPropertyAttributes")
    private Map<String, String> m_stringPropertyAttributes;
    @XmlElementWrapper(name="externalValueAttributes")
    private Map<String, String> m_externalValueAttributes;
    @XmlElementWrapper(name="rrdGraphAttributes")
    private Map<String, RrdGraphAttribute> m_rrdGraphAttributes;
    @XmlElementWrapper(name="graphNames")
    @XmlElement(name="graphName")
    private List<String> m_graphNames;
    @XmlTransient
    private OnmsResource m_resource;

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getLink() {
        return this.m_link;
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    public String getTypeLabel() {
        return this.m_typeLabel;
    }

    public void setTypeLabel(String typeLabel) {
        this.m_typeLabel = typeLabel;
    }

    public String getParentId() {
        return this.m_parentId;
    }

    public void setParentId(String parentId) {
        this.m_parentId = parentId;
    }

    public ResourceDTOCollection getChildren() {
        return this.m_children;
    }

    public void setChildren(ResourceDTOCollection children) {
        this.m_children = children;
    }

    public Map<String, String> getStringPropertyAttributes() {
        return this.m_stringPropertyAttributes;
    }

    public void setStringPropertyAttributes(Map<String, String> stringPropertyAttributes) {
        this.m_stringPropertyAttributes = stringPropertyAttributes;
    }

    public Map<String, String> getExternalValueAttributes() {
        return this.m_externalValueAttributes;
    }

    public void setExternalValueAttributes(Map<String, String> externalValueAttributes) {
        this.m_externalValueAttributes = externalValueAttributes;
    }

    public Map<String, RrdGraphAttribute> getRrdGraphAttributes() {
        return this.m_rrdGraphAttributes;
    }

    public void setGraphNames(List<String> graphNames) {
        this.m_graphNames = graphNames;
    }

    public void setRrdGraphAttributes(Map<String, RrdGraphAttribute> rrdGraphAttributes) {
        this.m_rrdGraphAttributes = rrdGraphAttributes;
    }

    public void setResource(OnmsResource resource) {
        this.m_resource = resource;
    }

    public OnmsResource getResource() {
        return this.m_resource;
    }

    public static ResourceDTO fromResource(OnmsResource resource, int depth) {
        ResourceDTO dto = new ResourceDTO();
        dto.setId(resource.getId().toString());
        dto.setLabel(resource.getLabel());
        dto.setName(resource.getName());
        dto.setLink(resource.getLink());
        dto.setTypeLabel(resource.getResourceType().getLabel());
        dto.setParentId(resource.getParent() == null ? null : resource.getParent().getId().toString());
        dto.setStringPropertyAttributes(resource.getStringPropertyAttributes());
        dto.setExternalValueAttributes(resource.getExternalValueAttributes());
        dto.setRrdGraphAttributes(resource.getRrdGraphAttributes());
        dto.setResource(resource);
        if (depth == 0) {
            dto.setChildren(null);
        } else {
            LinkedList<ResourceDTO> children = new LinkedList<ResourceDTO>();
            for (OnmsResource child : resource.getChildResources()) {
                children.add(ResourceDTO.fromResource(child, depth - 1));
            }
            dto.setChildren(new ResourceDTOCollection(children));
        }
        return dto;
    }
}

