/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import org.opennms.newts.cassandra.search.ResourceIdSplitter;

public class SimpleResourceIdSplitter
implements ResourceIdSplitter {
    private static Splitter s_pathSplitter = Splitter.on((char)':').omitEmptyStrings().trimResults();

    @Override
    public List<String> splitIdIntoElements(String id) {
        return s_pathSplitter.splitToList((CharSequence)id);
    }

    @Override
    public String joinElementsToId(List<String> elements) {
        Preconditions.checkNotNull(elements, (Object)"elements argument");
        StringBuilder sb = new StringBuilder();
        for (String el : elements) {
            String trimmedEl;
            if (el == null || (trimmedEl = el.trim()).length() < 1) continue;
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(trimmedEl);
        }
        return sb.toString();
    }
}

