/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponseRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("([1-5][0-9][0-9])(?:-([1-5][0-9][0-9]))?");
    private final int m_begin;
    private final int m_end;

    public HttpResponseRange(String rangeSpec) {
        Matcher matcher = RANGE_PATTERN.matcher(rangeSpec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid range spec: " + rangeSpec);
        }
        String beginSpec = matcher.group(1);
        String endSpec = matcher.group(2);
        this.m_begin = Integer.parseInt(beginSpec);
        this.m_end = endSpec == null ? this.m_begin : Integer.parseInt(endSpec);
    }

    public boolean contains(int responseCode) {
        return this.m_begin <= responseCode && responseCode <= this.m_end;
    }

    public String toString() {
        if (this.m_begin == this.m_end) {
            return Integer.toString(this.m_begin);
        }
        return Integer.toString(this.m_begin) + "-" + Integer.toString(this.m_end);
    }
}

