/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.utils.RegexUtils;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.ExcludeRange;
import org.opennms.netmgt.config.poller.Filter;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.Service;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Package
implements Serializable {
    private static final long serialVersionUID = 3522040891199184363L;
    @XmlAttribute(name="name")
    private String m_name;
    @Deprecated
    @XmlAttribute(name="remote")
    private Boolean m_remote;
    @XmlAttribute(name="perspective-only")
    private Boolean m_PerspectiveOnly;
    @XmlElement(name="filter")
    private Filter m_filter;
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="include-range")
    private List<IncludeRange> m_includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    private List<ExcludeRange> m_excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    private List<String> m_includeUrls = new ArrayList<String>();
    @XmlElement(name="rrd")
    private Rrd m_rrd;
    @XmlElement(name="service")
    private List<Service> m_services = new ArrayList<Service>();
    @XmlElement(name="outage-calendar")
    private List<String> m_outageCalendars = new ArrayList<String>();
    @XmlElement(name="downtime")
    private List<Downtime> m_downtimes = new ArrayList<Downtime>();

    public Package() {
    }

    public Package(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Deprecated
    public Boolean getRemote() {
        return this.m_remote == null ? false : this.m_remote;
    }

    @Deprecated
    public void setRemote(Boolean remote) {
        this.m_remote = remote;
    }

    public boolean getPerspectiveOnly() {
        return this.getRemote() != false || this.m_PerspectiveOnly != null && this.m_PerspectiveOnly != false;
    }

    public void setPerspectiveOnly(Boolean perspectiveOnly) {
        this.m_PerspectiveOnly = perspectiveOnly;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = new Filter(filter);
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public List<String> getSpecifics() {
        if (this.m_specifics == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_specifics);
    }

    public void setSpecifics(List<String> specifics) {
        this.m_specifics = new ArrayList<String>(specifics);
    }

    public void addSpecific(String specific) throws IndexOutOfBoundsException {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(String specific) {
        return this.m_specifics.remove(specific);
    }

    public List<IncludeRange> getIncludeRanges() {
        if (this.m_includeRanges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeRanges);
    }

    public void setIncludeRanges(List<IncludeRange> includeRanges) {
        this.m_includeRanges = new ArrayList<IncludeRange>(includeRanges);
    }

    public void addIncludeRange(IncludeRange includeRange) throws IndexOutOfBoundsException {
        this.m_includeRanges.add(includeRange);
    }

    public void addIncludeRange(String begin, String end) {
        this.addIncludeRange(new IncludeRange(begin, end));
    }

    public boolean removeIncludeRange(IncludeRange includeRange) {
        return this.m_includeRanges.remove(includeRange);
    }

    public List<ExcludeRange> getExcludeRanges() {
        if (this.m_excludeRanges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_excludeRanges);
    }

    public void setExcludeRanges(List<ExcludeRange> excludeRanges) {
        this.m_excludeRanges = new ArrayList<ExcludeRange>(excludeRanges);
    }

    public void addExcludeRange(ExcludeRange excludeRange) throws IndexOutOfBoundsException {
        this.m_excludeRanges.add(excludeRange);
    }

    public boolean removeExcludeRange(ExcludeRange excludeRange) {
        return this.m_excludeRanges.remove(excludeRange);
    }

    public List<String> getIncludeUrls() {
        if (this.m_includeUrls == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeUrls);
    }

    public void setIncludeUrls(List<String> includeUrls) {
        this.m_includeUrls = new ArrayList<String>(includeUrls);
    }

    public void addIncludeUrl(String includeUrl) throws IndexOutOfBoundsException {
        this.m_includeUrls.add(includeUrl);
    }

    public boolean removeIncludeUrl(String includeUrl) {
        return this.m_includeUrls.remove(includeUrl);
    }

    public Rrd getRrd() {
        return this.m_rrd;
    }

    public void setRrd(Rrd rrd) {
        this.m_rrd = rrd;
    }

    public List<Service> getServices() {
        if (this.m_services == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_services);
    }

    public void setServices(List<Service> services) {
        this.m_services = new ArrayList<Service>(services);
    }

    public void addService(Service service) throws IndexOutOfBoundsException {
        this.m_services.add(service);
    }

    public boolean removeService(Service service) {
        return this.m_services.remove(service);
    }

    public Service getService(String serviceName) {
        for (Service service : this.m_services) {
            if (!serviceName.equals(service.getName())) continue;
            return service;
        }
        return null;
    }

    public List<String> getOutageCalendars() {
        if (this.m_outageCalendars == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_outageCalendars);
    }

    public void setOutageCalendars(List<String> outageCalendars) {
        this.m_outageCalendars = new ArrayList<String>(outageCalendars);
    }

    public void addOutageCalendar(String outageCalendar) throws IndexOutOfBoundsException {
        this.m_outageCalendars.add(outageCalendar);
    }

    public boolean removeOutageCalendar(String outageCalendar) {
        return this.m_outageCalendars.remove(outageCalendar);
    }

    public List<Downtime> getDowntimes() {
        if (this.m_downtimes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_downtimes);
    }

    public void setDowntimes(List<Downtime> downtimes) {
        this.m_downtimes = new ArrayList<Downtime>(downtimes);
    }

    public void addDowntime(Downtime downtime) throws IndexOutOfBoundsException {
        this.m_downtimes.add(downtime);
    }

    public boolean removeDowntime(Downtime downtime) {
        return this.m_downtimes.remove(downtime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_downtimes == null ? 0 : this.m_downtimes.hashCode());
        result = 31 * result + (this.m_excludeRanges == null ? 0 : this.m_excludeRanges.hashCode());
        result = 31 * result + (this.m_filter == null ? 0 : this.m_filter.hashCode());
        result = 31 * result + (this.m_includeRanges == null ? 0 : this.m_includeRanges.hashCode());
        result = 31 * result + (this.m_includeUrls == null ? 0 : this.m_includeUrls.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_outageCalendars == null ? 0 : this.m_outageCalendars.hashCode());
        result = 31 * result + (this.m_remote == null ? 0 : this.m_remote.hashCode());
        result = 31 * result + (this.m_rrd == null ? 0 : this.m_rrd.hashCode());
        result = 31 * result + (this.m_services == null ? 0 : this.m_services.hashCode());
        result = 31 * result + (this.m_specifics == null ? 0 : this.m_specifics.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Package)) {
            return false;
        }
        Package other = (Package)obj;
        if (this.m_downtimes == null ? other.m_downtimes != null : !this.m_downtimes.equals(other.m_downtimes)) {
            return false;
        }
        if (this.m_excludeRanges == null ? other.m_excludeRanges != null : !this.m_excludeRanges.equals(other.m_excludeRanges)) {
            return false;
        }
        if (this.m_filter == null ? other.m_filter != null : !this.m_filter.equals(other.m_filter)) {
            return false;
        }
        if (this.m_includeRanges == null ? other.m_includeRanges != null : !this.m_includeRanges.equals(other.m_includeRanges)) {
            return false;
        }
        if (this.m_includeUrls == null ? other.m_includeUrls != null : !this.m_includeUrls.equals(other.m_includeUrls)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_outageCalendars == null ? other.m_outageCalendars != null : !this.m_outageCalendars.equals(other.m_outageCalendars)) {
            return false;
        }
        if (this.m_remote == null ? other.m_remote != null : !this.m_remote.equals(other.m_remote)) {
            return false;
        }
        if (this.m_rrd == null ? other.m_rrd != null : !this.m_rrd.equals(other.m_rrd)) {
            return false;
        }
        if (this.m_services == null ? other.m_services != null : !this.m_services.equals(other.m_services)) {
            return false;
        }
        return !(this.m_specifics == null ? other.m_specifics != null : !this.m_specifics.equals(other.m_specifics));
    }

    public String toString() {
        return "Package[name=" + this.m_name + ",remote=" + this.m_remote + ",filter=" + String.valueOf(this.m_filter) + ",specifics=" + String.valueOf(this.m_specifics) + ",includeRanges=" + String.valueOf(this.m_includeRanges) + ",excludeRanges=" + String.valueOf(this.m_excludeRanges) + ",includeUrls=" + String.valueOf(this.m_includeUrls) + ",rrd=" + String.valueOf(this.m_rrd) + ",services=" + String.valueOf(this.m_services) + ",outageCalendars=" + String.valueOf(this.m_outageCalendars) + ",downtimes=" + String.valueOf(this.m_downtimes) + "]";
    }

    public Optional<ServiceMatch> findService(String svcName) {
        for (Service service : this.getServices()) {
            if (!service.getName().equalsIgnoreCase(svcName)) continue;
            return Optional.of(new ServiceMatch(this, service));
        }
        for (Service service : this.getServices()) {
            Pattern pattern;
            Matcher matcher;
            String status = service.getStatus();
            if (status != null && !status.equals("on") || Strings.isNullOrEmpty((String)service.getPattern()) || !(matcher = (pattern = Pattern.compile(service.getPattern())).matcher(svcName)).matches()) continue;
            Map patternVariables = Maps.filterValues((Map)Maps.asMap((Set)RegexUtils.getNamedCaptureGroupsFromPattern((String)service.getPattern()), matcher::group), Objects::nonNull);
            return Optional.of(new ServiceMatch(this, service, svcName, patternVariables));
        }
        return Optional.empty();
    }

    public static class ServiceMatch {
        public final Package pakkage;
        public final Service service;
        public final String serviceName;
        public final Map<String, String> patternVariables;

        public ServiceMatch(Package pakkage, Service service, String serviceName, Map<String, String> patternVariables) {
            this.pakkage = Objects.requireNonNull(pakkage);
            this.service = Objects.requireNonNull(service);
            this.serviceName = Objects.requireNonNull(serviceName);
            this.patternVariables = Objects.requireNonNull(patternVariables);
        }

        public ServiceMatch(Package pakkage, Service service) {
            this(pakkage, service, service.getName(), Collections.emptyMap());
        }
    }
}

