/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.config.internal.collection.DatacollectionConfigVisitor;

@XmlRootElement(name="group", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"m_name", "m_ifType", "m_mibObjects", "m_mibObjProperties", "m_includeGroups"})
@ValidateUsing(value="datacollection-config.xsd")
public class Group
implements Serializable {
    private static final long serialVersionUID = -4798682461748675616L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="ifType", required=true)
    private String m_ifType;
    @XmlElement(name="mibObj")
    private List<MibObj> m_mibObjects = new ArrayList<MibObj>();
    @XmlElement(name="includeGroup")
    private List<String> m_includeGroups = new ArrayList<String>();
    @XmlElement(name="property")
    private List<MibObjProperty> m_mibObjProperties = new ArrayList<MibObjProperty>();

    public Group() {
    }

    public Group(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name == null ? null : name.intern();
    }

    public String getIfType() {
        return this.m_ifType;
    }

    public void setIfType(String ifType) {
        this.m_ifType = ifType == null ? null : ifType.intern();
    }

    public List<MibObj> getMibObjs() {
        if (this.m_mibObjects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_mibObjects);
    }

    public void setMibObjs(List<MibObj> mibObjs) {
        this.m_mibObjects = new ArrayList<MibObj>(mibObjs);
    }

    public void addMibObj(MibObj mibObj) throws IndexOutOfBoundsException {
        this.m_mibObjects.add(mibObj);
    }

    public boolean removeMibObj(MibObj mibObj) {
        return this.m_mibObjects.remove(mibObj);
    }

    public List<String> getIncludeGroups() {
        if (this.m_includeGroups == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_includeGroups);
    }

    public void setIncludeGroups(List<String> includeGroups) {
        this.m_includeGroups = new ArrayList<String>(includeGroups);
    }

    public void addIncludeGroup(String includeGroup) throws IndexOutOfBoundsException {
        this.m_includeGroups.add(includeGroup == null ? null : includeGroup.intern());
    }

    public boolean removeIncludeGroup(String includeGroup) {
        return this.m_includeGroups.remove(includeGroup);
    }

    public List<MibObjProperty> getProperties() {
        return this.m_mibObjProperties;
    }

    public void setProperties(List<MibObjProperty> mibObjProperties) {
        this.m_mibObjProperties = mibObjProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_ifType == null ? 0 : this.m_ifType.hashCode());
        result = 31 * result + (this.m_includeGroups == null ? 0 : this.m_includeGroups.hashCode());
        result = 31 * result + (this.m_mibObjects == null ? 0 : this.m_mibObjects.hashCode());
        result = 31 * result + (this.m_mibObjProperties == null ? 0 : this.m_mibObjProperties.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.m_ifType == null ? other.m_ifType != null : !this.m_ifType.equals(other.m_ifType)) {
            return false;
        }
        if (this.m_includeGroups == null ? other.m_includeGroups != null : !this.m_includeGroups.equals(other.m_includeGroups)) {
            return false;
        }
        if (this.m_mibObjects == null ? other.m_mibObjects != null : !this.m_mibObjects.equals(other.m_mibObjects)) {
            return false;
        }
        if (this.m_mibObjProperties == null ? other.m_mibObjProperties != null : !this.m_mibObjProperties.equals(other.m_mibObjProperties)) {
            return false;
        }
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }

    public String toString() {
        return "Group [name=" + this.m_name + ", ifType=" + this.m_ifType + ", mibObjects=" + String.valueOf(this.m_mibObjects) + ", includeGroups=" + String.valueOf(this.m_includeGroups) + ", mibObjProperties=" + String.valueOf(this.m_mibObjProperties) + "]";
    }

    public void visit(DatacollectionConfigVisitor visitor) {
        visitor.visitGroup(this);
        if (this.m_mibObjects != null) {
            for (MibObj obj : this.m_mibObjects) {
                obj.visit(visitor);
            }
        }
        visitor.visitGroupComplete();
    }
}

