/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.dao.api.MemoDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsReductionKeyMemo;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.opennms.netmgt.model.alarm.SituationSummary;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class AlarmRepositoryHibernate
implements AlarmRepository,
InitializingBean {
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private MemoDao m_memoDao;
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Autowired
    private AlarmEntityNotifier m_alarmEntityNotifier;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    @Transactional
    public void acknowledgeAll(String user, Date timestamp) {
        this.acknowledgeMatchingAlarms(user, timestamp, new OnmsCriteria(OnmsAlarm.class));
    }

    @Transactional
    public void acknowledgeAlarms(String user, Date timestamp, int[] alarmIds) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.add(Restrictions.in((String)"id", this.findRelatedAlarms(alarmIds)));
        this.acknowledgeMatchingAlarms(user, timestamp, criteria);
    }

    @Override
    @Transactional
    public void acknowledgeMatchingAlarms(String user, Date timestamp, OnmsCriteria criteria) {
        List alarms = this.m_alarmDao.findMatching(criteria);
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.ACKNOWLEDGE);
            this.m_ackDao.processAck(ack);
        }
    }

    @Override
    @Transactional
    public void clearAlarms(int[] alarmIds, String user, Date timestamp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.add(Restrictions.in((String)"id", Arrays.asList(ArrayUtils.toObject((int[])alarmIds))));
        List alarms = this.m_alarmDao.findMatching(criteria);
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.CLEAR);
            this.m_ackDao.processAck(ack);
        }
    }

    @Override
    @Transactional
    public int countMatchingAlarms(OnmsCriteria criteria) {
        return this.m_alarmDao.countMatching(criteria);
    }

    @Override
    @Transactional
    public int[] countMatchingAlarmsBySeverity(OnmsCriteria criteria) {
        int[] alarmCounts = new int[8];
        for (OnmsSeverity value : OnmsSeverity.values()) {
            alarmCounts[value.getId()] = this.m_alarmDao.countMatching(criteria.doClone().add((Criterion)Restrictions.eq((String)"severity", (Object)value)));
        }
        return alarmCounts;
    }

    @Override
    @Transactional
    public void escalateAlarms(int[] alarmIds, String user, Date timestamp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.add(Restrictions.in((String)"id", Arrays.asList(ArrayUtils.toObject((int[])alarmIds))));
        List alarms = this.m_alarmDao.findMatching(criteria);
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckTime(timestamp);
            ack.setAckAction(AckAction.ESCALATE);
            this.m_ackDao.processAck(ack);
        }
    }

    @Override
    @Transactional
    public OnmsAlarm getAlarm(int alarmId) {
        return (OnmsAlarm)this.m_alarmDao.get(alarmId);
    }

    @Override
    @Transactional
    public OnmsAlarm[] getMatchingAlarms(OnmsCriteria criteria) {
        List<OnmsAlarm> alarms = this.m_alarmDao.findMatching(criteria);
        return alarms == null ? new OnmsAlarm[]{} : alarms.toArray(new OnmsAlarm[0]);
    }

    @Override
    @Transactional
    public void unacknowledgeAll(String user) {
        this.unacknowledgeMatchingAlarms(new OnmsCriteria(OnmsAlarm.class), user);
    }

    @Override
    @Transactional
    public void unacknowledgeMatchingAlarms(OnmsCriteria criteria, String user) {
        List alarms = this.m_alarmDao.findMatching(criteria);
        for (OnmsAlarm alarm : alarms) {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
            this.m_ackDao.processAck(ack);
        }
    }

    @Override
    @Transactional
    public void acknowledgeAlarms(int[] alarmIds, String user, Date timestamp) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.add(Restrictions.in((String)"id", this.findRelatedAlarms(alarmIds)));
        this.acknowledgeMatchingAlarms(user, timestamp, criteria);
    }

    @Override
    @Transactional
    public void unacknowledgeAlarms(int[] alarmIds, String user) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.add(Restrictions.in((String)"id", Arrays.asList(ArrayUtils.toObject((int[])alarmIds))));
        this.unacknowledgeMatchingAlarms(criteria, user);
    }

    private Set<Integer> findRelatedAlarms(int[] alarmIds) {
        Set relatedAlarms;
        HashSet<Integer> allAlarmIds = new HashSet<Integer>();
        Set<Object> toBeChecked = Sets.newHashSet((Object[])ArrayUtils.toObject((int[])alarmIds));
        do {
            allAlarmIds.addAll(toBeChecked);
        } while (!(toBeChecked = (relatedAlarms = toBeChecked.stream().map(i -> this.getAlarm((int)i)).filter(o -> o.isSituation()).flatMap(o -> o.getRelatedAlarmIds().stream()).collect(Collectors.toSet()))).isEmpty());
        return allAlarmIds;
    }

    @Override
    @Transactional
    public void updateStickyMemo(Integer alarmId, String body, String user) {
        OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get(alarmId);
        if (onmsAlarm != null) {
            if (onmsAlarm.getStickyMemo() == null) {
                onmsAlarm.setStickyMemo(new OnmsMemo());
                onmsAlarm.getStickyMemo().setCreated(new Date());
            }
            String previousBody = onmsAlarm.getStickyMemo().getBody();
            String previousAuthor = onmsAlarm.getStickyMemo().getAuthor();
            Date previousUpdated = onmsAlarm.getStickyMemo().getUpdated();
            onmsAlarm.getStickyMemo().setBody(body);
            onmsAlarm.getStickyMemo().setAuthor(user);
            onmsAlarm.getStickyMemo().setUpdated(new Date());
            this.m_alarmDao.saveOrUpdate(onmsAlarm);
            this.m_alarmEntityNotifier.didUpdateStickyMemo(onmsAlarm, previousBody, previousAuthor, previousUpdated);
        }
    }

    @Override
    @Transactional
    public void updateReductionKeyMemo(Integer alarmId, String body, String user) {
        OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get(alarmId);
        if (onmsAlarm != null) {
            OnmsReductionKeyMemo memo = onmsAlarm.getReductionKeyMemo();
            if (memo == null) {
                memo = new OnmsReductionKeyMemo();
                memo.setCreated(new Date());
            }
            String previousBody = memo.getBody();
            String previousAuthor = memo.getAuthor();
            Date previousUpdated = memo.getUpdated();
            memo.setBody(body);
            memo.setAuthor(user);
            memo.setReductionKey(onmsAlarm.getReductionKey());
            memo.setUpdated(new Date());
            this.m_memoDao.saveOrUpdate(memo);
            onmsAlarm.setReductionKeyMemo(memo);
            this.m_alarmEntityNotifier.didUpdateReductionKeyMemo(onmsAlarm, previousBody, previousAuthor, previousUpdated);
        }
    }

    @Override
    @Transactional
    public void removeStickyMemo(Integer alarmId) {
        OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get(alarmId);
        if (onmsAlarm != null && onmsAlarm.getStickyMemo() != null) {
            OnmsMemo stickyMemo = onmsAlarm.getStickyMemo();
            this.m_memoDao.delete(onmsAlarm.getStickyMemo());
            onmsAlarm.setStickyMemo(null);
            this.m_alarmEntityNotifier.didDeleteStickyMemo(onmsAlarm, stickyMemo);
        }
    }

    @Override
    @Transactional
    public void removeReductionKeyMemo(int alarmId) {
        OnmsAlarm onmsAlarm = (OnmsAlarm)this.m_alarmDao.get(alarmId);
        if (onmsAlarm != null && onmsAlarm.getReductionKeyMemo() != null) {
            OnmsReductionKeyMemo reductionKeyMemo = onmsAlarm.getReductionKeyMemo();
            this.m_memoDao.delete(onmsAlarm.getReductionKeyMemo());
            onmsAlarm.setReductionKeyMemo(null);
            this.m_alarmEntityNotifier.didDeleteReductionKeyMemo(onmsAlarm, reductionKeyMemo);
        }
    }

    @Override
    @Transactional
    public List<OnmsAcknowledgment> getAcknowledgments(int alarmId) {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAcknowledgment.class);
        cb.eq("refId", (Object)alarmId);
        cb.eq("ackType", (Object)AckType.ALARM);
        return this.m_ackDao.findMatching(cb.toCriteria());
    }

    @Override
    @Transactional
    public List<AlarmSummary> getCurrentNodeAlarmSummaries() {
        return this.m_alarmDao.getNodeAlarmSummaries();
    }

    @Override
    @Transactional
    public List<SituationSummary> getCurrentSituationSummaries() {
        return this.m_alarmDao.getSituationSummaries();
    }
}

