/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.network;

import java.util.Objects;

public class IPPortRange {
    private final int begin;
    private final int end;

    public IPPortRange(int begin, int end) {
        if (begin < 0 || end > 65535 || begin > end) {
            throw new IllegalArgumentException("invalid port range - begin: " + begin + "; end: " + end);
        }
        this.begin = begin;
        this.end = end;
    }

    public IPPortRange(int port) {
        this(port, port);
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean contains(int port) {
        return this.begin <= port && this.end >= port;
    }

    public String toString() {
        return "IPPortRange{begin=" + this.begin + ", end=" + this.end + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPPortRange that = (IPPortRange)o;
        return this.begin == that.begin && this.end == that.end;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }
}

