/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.camel.client;

import com.codahale.metrics.MetricRegistry;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.sink.camel.server.CamelMessageConsumerManager;
import org.opennms.core.ipc.sink.common.AbstractMessageDispatcherFactory;
import org.opennms.core.tracing.api.TracerRegistry;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelLocalMessageDispatcherFactory
extends AbstractMessageDispatcherFactory<Void>
implements InitializingBean,
DisposableBean {
    @Autowired
    private CamelMessageConsumerManager messageConsumerManager;
    @Autowired
    private TracerRegistry tracerRegistry;
    private MetricRegistry metrics;

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> module, Void metadata, T message) {
        this.messageConsumerManager.dispatch(module, message);
    }

    public String getMetricDomain() {
        return "org.opennms.core.ipc.sink.producer";
    }

    public BundleContext getBundleContext() {
        return null;
    }

    public TracerRegistry getTracerRegistry() {
        return this.tracerRegistry;
    }

    public void setTracerRegistry(TracerRegistry tracerRegistry) {
        this.tracerRegistry = tracerRegistry;
    }

    public Tracer getTracer() {
        if (this.getTracerRegistry() != null) {
            return this.getTracerRegistry().getTracer();
        }
        return GlobalTracer.get();
    }

    public void afterPropertiesSet() {
        this.onInit();
    }

    public void destroy() {
        this.onDestroy();
    }

    public MetricRegistry getMetrics() {
        if (this.metrics == null) {
            this.metrics = new MetricRegistry();
        }
        return this.metrics;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }
}

