/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sctp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.PreConditions;
import io.pkts.packet.sctp.SctpChunk;
import io.pkts.packet.sctp.SctpParseException;
import java.io.IOException;

public class DefaultSctpChunk
implements SctpChunk {
    private final SctpChunk.Type type;
    private final Buffer header;
    private final Buffer value;
    private final int padding;

    public static DefaultSctpChunk frame(Buffer buffer) {
        try {
            Buffers.assertNotEmpty((Buffer)buffer, (String)"The buffer cannot be null or empty");
            PreConditions.assertArgument(buffer.getReadableBytes() >= 4, "There must be at least 4 bytes to read");
            Buffer header = buffer.readBytes(4);
            SctpChunk.Type type = SctpChunk.lookup(header.getUnsignedByte(0));
            int length = header.getUnsignedShort(2) - 4;
            int padding = DefaultSctpChunk.calculatePadding(length);
            PreConditions.assertArgument(buffer.getReadableBytes() >= length + padding, "Unable to read Chunk Value. Not enough bytes. Needed " + (length + padding) + " bytes but only " + buffer.getReadableBytes() + " bytes available");
            Buffer value = buffer.readBytes(length);
            buffer.readBytes(padding);
            return new DefaultSctpChunk(type, header, value, padding);
        }
        catch (IOException e) {
            throw new SctpParseException(buffer.getReaderIndex(), "Unable to read from buffer. Message (if any) " + e.getMessage());
        }
    }

    private DefaultSctpChunk(SctpChunk.Type type, Buffer header, Buffer valueOnWire, int padding) {
        this.type = type;
        this.header = header;
        this.value = valueOnWire;
        this.padding = padding;
    }

    @Override
    public SctpChunk.Type getType() {
        return this.type;
    }

    @Override
    public int getLength() {
        return 4 + this.value.capacity() + this.padding;
    }

    @Override
    public Buffer getHeader() {
        return this.header;
    }

    @Override
    public Buffer getValue() {
        return this.value;
    }

    @Override
    public byte getFlags() {
        try {
            return this.header.getByte(1);
        }
        catch (IOException e) {
            throw new SctpParseException(1, "IOException when reading flags");
        }
    }

    @Override
    public int getValueLength() {
        return this.value.capacity();
    }

    @Override
    public int getPadding() {
        return this.padding;
    }

    private static int calculatePadding(int length) {
        int padding = length % 4;
        if (padding != 0) {
            return 4 - padding;
        }
        return 0;
    }
}

