/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.ConnectionHandlingStompSession;
import org.springframework.messaging.simp.stomp.Reactor2StompCodec;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompEncoder;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.Reactor2TcpClient;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.config.ConfigurationReader;
import reactor.core.config.DispatcherConfiguration;
import reactor.core.config.DispatcherType;
import reactor.core.config.ReactorConfiguration;
import reactor.io.codec.Codec;
import reactor.io.net.NetStreams;
import reactor.io.net.Spec;

public class Reactor2TcpStompClient
extends StompClientSupport {
    private final TcpOperations<byte[]> tcpClient;

    public Reactor2TcpStompClient() {
        this("127.0.0.1", 61613);
    }

    public Reactor2TcpStompClient(String host, int port) {
        StompClientDispatcherConfigReader reader = new StompClientDispatcherConfigReader();
        Environment environment = new Environment((ConfigurationReader)reader).assignErrorJournal();
        StompTcpClientSpecFactory factory = new StompTcpClientSpecFactory(environment, host, port);
        this.tcpClient = new Reactor2TcpClient<byte[]>(factory);
    }

    public Reactor2TcpStompClient(TcpOperations<byte[]> tcpClient) {
        this.tcpClient = tcpClient;
    }

    public ListenableFuture<StompSession> connect(StompSessionHandler handler) {
        return this.connect(null, handler);
    }

    public ListenableFuture<StompSession> connect(StompHeaders connectHeaders, StompSessionHandler handler) {
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, handler);
        this.tcpClient.connect(session);
        return session.getSessionFuture();
    }

    public void shutdown() {
        this.tcpClient.shutdown();
    }

    private static class StompTcpClientSpecFactory
    implements NetStreams.TcpClientFactory<Message<byte[]>, Message<byte[]>> {
        private final Environment environment;
        private final String host;
        private final int port;

        public StompTcpClientSpecFactory(Environment environment, String host, int port) {
            this.environment = environment;
            this.host = host;
            this.port = port;
        }

        public Spec.TcpClientSpec<Message<byte[]>, Message<byte[]>> apply(Spec.TcpClientSpec<Message<byte[]>, Message<byte[]>> tcpClientSpec) {
            return ((Spec.TcpClientSpec)((Spec.TcpClientSpec)tcpClientSpec.codec((Codec)new Reactor2StompCodec(new StompEncoder(), new StompDecoder())).env(this.environment)).dispatcher((Dispatcher)this.environment.getCachedDispatchers("StompClient").get())).connect(this.host, this.port);
        }
    }

    private static class StompClientDispatcherConfigReader
    implements ConfigurationReader {
        private StompClientDispatcherConfigReader() {
        }

        public ReactorConfiguration read() {
            String dispatcherName = "StompClient";
            DispatcherType dispatcherType = DispatcherType.DISPATCHER_GROUP;
            DispatcherConfiguration config = new DispatcherConfiguration(dispatcherName, dispatcherType, Integer.valueOf(128), Integer.valueOf(0));
            List<DispatcherConfiguration> configList = Collections.singletonList(config);
            return new ReactorConfiguration(configList, dispatcherName, new Properties());
        }
    }
}

