/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.distributed.core.impl;

import java.util.concurrent.Callable;
import org.opennms.core.health.api.HealthCheckResponseCache;
import org.opennms.core.health.api.Response;
import org.opennms.distributed.core.api.RestClient;

public class HealthTrackingRestClient
implements RestClient {
    private final RestClient delegate;
    private final HealthCheckResponseCache healthCheckResponseCache;

    public HealthTrackingRestClient(RestClient delegate, HealthCheckResponseCache healthCheckResponseCache) {
        this.delegate = delegate;
        this.healthCheckResponseCache = healthCheckResponseCache;
    }

    private <T> T callAndInformCachingHealthCheck(Callable<T> callable) throws Exception {
        try {
            T v = callable.call();
            if (this.healthCheckResponseCache != null) {
                this.healthCheckResponseCache.setResponse(Response.SUCCESS);
            }
            return v;
        }
        catch (Throwable e) {
            if (this.healthCheckResponseCache != null) {
                this.healthCheckResponseCache.setResponse(new Response(e));
            }
            throw e;
        }
    }

    public String getVersion() throws Exception {
        return this.callAndInformCachingHealthCheck(() -> ((RestClient)this.delegate).getVersion());
    }

    public void ping() throws Exception {
        this.callAndInformCachingHealthCheck(() -> {
            this.delegate.ping();
            return null;
        });
    }

    public String getSnmpV3Users() throws Exception {
        return this.callAndInformCachingHealthCheck(() -> ((RestClient)this.delegate).getSnmpV3Users());
    }
}

