/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.elastic.client.model.SearchRequest;
import org.opennms.features.elastic.client.model.SearchResponse;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.FlowQueryService;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticFlowQueryService
implements FlowQueryService {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticFlowQueryService.class);
    private final ElasticRestClient client;
    private final IndexSelector indexSelector;

    public ElasticFlowQueryService(ElasticRestClient client, IndexSelector indexSelector) {
        this.client = Objects.requireNonNull(client);
        this.indexSelector = Objects.requireNonNull(indexSelector);
    }

    protected static <T> CompletableFuture<Table<Directional<T>, Long, Double>> mapTable(Table<Directional<String>, Long, Double> source, Function<String, CompletableFuture<T>> fn) {
        Set columnKeys = source.columnKeySet();
        List<CompletableFuture<T>> rowKeys = source.rowKeySet().stream().map(rk -> ((CompletableFuture)fn.apply((String)rk.getValue())).thenApply(t -> Maps.immutableEntry((Object)new Directional(t, rk.isIngress()), (Object)source.row(rk)))).collect(Collectors.toList());
        return ElasticFlowQueryService.transpose(rowKeys, Collectors.toList()).thenApply(rows -> {
            ImmutableTable.Builder target = ImmutableTable.builder();
            for (Map.Entry row : rows) {
                for (Long columnKey : columnKeys) {
                    Double value = (Double)((Map)row.getValue()).get(columnKey);
                    if (value == null) {
                        value = Double.NaN;
                    }
                    target.put((Object)((Directional)row.getKey()), (Object)columnKey, (Object)value);
                }
            }
            return target.build();
        });
    }

    protected static <T, A, R> CompletableFuture<R> transpose(Iterable<CompletableFuture<T>> futures, Collector<? super T, A, R> collector) {
        CompletableFuture[] array = (CompletableFuture[])Iterables.toArray(futures, CompletableFuture.class);
        return CompletableFuture.allOf(array).thenApply(v -> Arrays.stream(array).map(CompletableFuture::join).collect(collector));
    }

    public CompletableFuture<SearchResponse> searchAsync(String query, TimeRangeFilter timeRangeFilter) {
        List indices;
        if (timeRangeFilter != null) {
            indices = this.indexSelector.getIndexNames(timeRangeFilter.getStart(), timeRangeFilter.getEnd());
            LOG.debug("Executing asynchronous query on {}: {}", (Object)indices, (Object)query);
        } else {
            indices = List.of("netflow-*");
            LOG.debug("Executing asynchronous query on all indices: {}", (Object)query);
        }
        SearchRequest searchRequest = SearchRequest.forIndices((List)indices, (String)query);
        searchRequest.addParameter("ignore_unavailable", "true");
        return this.client.searchAsync(searchRequest);
    }
}

