/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.template.TemplateInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposableTemplateInitializer
implements TemplateInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ComposableTemplateInitializer.class);
    private static final long[] COOL_DOWN_TIMES_IN_MS = new long[]{250L, 500L, 1000L, 5000L, 10000L, 60000L};
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final ElasticRestClient elasticRestClient;
    private boolean initialized = false;
    private final String templatesPath;
    private final boolean useComposableTemplates;

    public ComposableTemplateInitializer(ElasticRestClient elasticRestClient, String templatesPath, boolean useComposableTemplates) {
        this.elasticRestClient = elasticRestClient;
        this.templatesPath = this.resolveTemplatesPath(templatesPath);
        this.useComposableTemplates = useComposableTemplates;
    }

    public void initialize() {
        if (!this.useComposableTemplates) {
            return;
        }
        int count = 0;
        while (!this.initialized && !Thread.interrupted()) {
            try {
                LOG.debug("Composable Templates are not initialized. Initializing...");
                count = this.doInitialize();
            }
            catch (ConnectionPoolShutdownException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("An error occurred while initializing composable templates {}", (Object)ex.getMessage(), (Object)ex);
            }
            if (count == 0) {
                long coolDownTimeInMs = COOL_DOWN_TIMES_IN_MS[this.retryCount.get()];
                LOG.debug("Retrying in {} ms", (Object)coolDownTimeInMs);
                this.waitBeforeRetrying(coolDownTimeInMs);
                if (this.retryCount.get() == COOL_DOWN_TIMES_IN_MS.length - 1) continue;
                this.retryCount.incrementAndGet();
                continue;
            }
            this.initialized = true;
        }
    }

    private String resolveTemplatesPath(String templatesPath) {
        if (templatesPath == null || templatesPath.isBlank() || templatesPath.contains("karaf.etc")) {
            Path pathForTemplates = Paths.get(System.getProperty("karaf.etc"), "netflow-templates");
            return pathForTemplates.toString();
        }
        return templatesPath;
    }

    private void waitBeforeRetrying(long cooldown) {
        try {
            Thread.sleep(cooldown);
        }
        catch (InterruptedException e) {
            LOG.warn("Sleep was interrupted", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isComposableTemplate() {
        return true;
    }

    private int doInitialize() throws IOException {
        int count = 0;
        File templatesDir = new File(this.templatesPath);
        if (templatesDir.exists() && templatesDir.isDirectory()) {
            try {
                count = this.elasticRestClient.applyAllTemplatesFromDirectory(this.templatesPath);
                if (count > 0) {
                    LOG.info("Successfully applied {} composable templates from the dir: {}", (Object)count, (Object)this.templatesPath);
                }
            }
            catch (Exception e) {
                LOG.warn("Error while trying to apply composable templates: {} from the dir: {}", new Object[]{e.getMessage(), this.templatesPath, e});
            }
        }
        return count;
    }
}

