/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import io.hawt.util.IOHelper;
import io.hawt.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Objects {
    private static final transient Logger LOG = LoggerFactory.getLogger(Objects.class);

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static int compare(Comparable a, Comparable b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(Class<?> aClass, String groupId, String artifactId) {
        Package aPackage;
        String version = null;
        InputStream is = null;
        String fileName = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        try {
            Properties p = new Properties();
            is = aClass.getResourceAsStream(fileName);
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception p) {
        }
        finally {
            if (is != null) {
                IOHelper.close(is, fileName, LOG);
            }
        }
        if (version == null && (aPackage = aClass.getPackage()) != null && Strings.isBlank(version = aPackage.getImplementationVersion())) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            Enumeration<URL> resources = null;
            try {
                resources = aClass.getClassLoader().getResources("META-INF/MANIFEST.MF");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resources != null) {
                String expectedBundleName = groupId + "." + artifactId;
                while (resources.hasMoreElements()) {
                    try {
                        Manifest manifest = new Manifest(resources.nextElement().openStream());
                        Attributes attributes = manifest.getMainAttributes();
                        String bundleName = attributes.getValue("Bundle-SymbolicName");
                        if (!Objects.equals(expectedBundleName, bundleName) || !Strings.isNotBlank(version = attributes.getValue("Implementation-Version"))) continue;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        return version;
    }
}

