/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TreeNode
extends HashMap {
    private static Log logger = LogFactory.getLog(TreeNode.class);
    private Object identifier;
    private Object bean;
    private TreeNode parent;
    private List children;
    private int depth;
    private boolean open;

    public TreeNode() {
    }

    public TreeNode(Object bean, Object identifier, int depth) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean instanceof Map) {
            this.putAll((Map)bean);
        } else {
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean.getClass());
            for (int i = 0; i < descriptors.length; ++i) {
                this.put(descriptors[i].getName(), BeanUtils.getProperty((Object)bean, (String)descriptors[i].getName()));
            }
        }
        this.setBean(bean);
        this.identifier = identifier;
        this.depth = depth;
    }

    public void addChild(Object child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < descriptors.length; ++i) {
            try {
                String propertyName = descriptors[i].getDisplayName();
                String val = BeanUtils.getProperty((Object)bean, (String)propertyName);
                this.put(propertyName, val);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"TreeNode.setBean() Problem", (Throwable)e);
            }
        }
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Object object) {
        this.identifier = object;
    }

    @Override
    public boolean equals(Object obj) {
        TreeNode node = (TreeNode)obj;
        return super.equals(obj) || this.identifier.equals(node.getIdentifier());
    }
}

