/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.core.Messages;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.table.view.html.TableActions;
import org.extremecomponents.table.view.html.toolbar.ButtonItem;
import org.extremecomponents.table.view.html.toolbar.ImageItem;
import org.extremecomponents.table.view.html.toolbar.TextItem;
import org.extremecomponents.table.view.html.toolbar.ToolbarItemUtils;
import org.extremecomponents.util.HtmlBuilder;

public class ToolbarBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Messages messages;

    public ToolbarBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public ToolbarBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.messages = model.getMessages();
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected Messages getMessages() {
        return this.messages;
    }

    public void firstPageItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.firstPage"));
        item.setContents(this.messages.getMessage("toolbar.text.firstPage"));
        ToolbarItemUtils.buildFirstPage(this.html, this.model, item);
    }

    public void firstPageItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.firstPage"));
        item.setDisabledImage(BuilderUtils.getImage(this.model, "firstPageDisabled"));
        item.setImage(BuilderUtils.getImage(this.model, "firstPage"));
        item.setAlt(this.messages.getMessage("toolbar.text.firstPage"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildFirstPage(this.html, this.model, item);
    }

    public void firstPageItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.firstPage"));
        item.setText(this.messages.getMessage("toolbar.text.firstPage"));
        ToolbarItemUtils.buildFirstPage(this.html, this.model, item);
    }

    public void prevPageItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.prevPage"));
        item.setContents(this.messages.getMessage("toolbar.text.prevPage"));
        ToolbarItemUtils.buildPrevPage(this.html, this.model, item);
    }

    public void prevPageItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.prevPage"));
        item.setDisabledImage(BuilderUtils.getImage(this.model, "prevPageDisabled"));
        item.setImage(BuilderUtils.getImage(this.model, "prevPage"));
        item.setAlt(this.messages.getMessage("toolbar.text.prevPage"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildPrevPage(this.html, this.model, item);
    }

    public void prevPageItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.prevPage"));
        item.setText(this.messages.getMessage("toolbar.text.prevPage"));
        ToolbarItemUtils.buildPrevPage(this.html, this.model, item);
    }

    public void nextPageItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.nextPage"));
        item.setContents(this.messages.getMessage("toolbar.text.nextPage"));
        ToolbarItemUtils.buildNextPage(this.html, this.model, item);
    }

    public void nextPageItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.nextPage"));
        item.setDisabledImage(BuilderUtils.getImage(this.model, "nextPageDisabled"));
        item.setImage(BuilderUtils.getImage(this.model, "nextPage"));
        item.setAlt(this.messages.getMessage("toolbar.text.nextPage"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildNextPage(this.html, this.model, item);
    }

    public void nextPageItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.nextPage"));
        item.setText(this.messages.getMessage("toolbar.text.nextPage"));
        ToolbarItemUtils.buildNextPage(this.html, this.model, item);
    }

    public void lastPageItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.lastPage"));
        item.setContents(this.messages.getMessage("toolbar.text.lastPage"));
        ToolbarItemUtils.buildLastPage(this.html, this.model, item);
    }

    public void lastPageItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.lastPage"));
        item.setDisabledImage(BuilderUtils.getImage(this.model, "lastPageDisabled"));
        item.setImage(BuilderUtils.getImage(this.model, "lastPage"));
        item.setAlt(this.messages.getMessage("toolbar.text.lastPage"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildLastPage(this.html, this.model, item);
    }

    public void lastPageItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.lastPage"));
        item.setText(this.messages.getMessage("toolbar.text.lastPage"));
        ToolbarItemUtils.buildLastPage(this.html, this.model, item);
    }

    public void filterItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.filter"));
        item.setContents(this.messages.getMessage("toolbar.text.filter"));
        ToolbarItemUtils.buildFilter(this.html, this.model, item);
    }

    public void filterItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.filter"));
        item.setImage(BuilderUtils.getImage(this.model, "filter"));
        item.setAlt(this.messages.getMessage("toolbar.text.filter"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildFilter(this.html, this.model, item);
    }

    public void filterItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.filter"));
        item.setText(this.messages.getMessage("toolbar.text.filter"));
        ToolbarItemUtils.buildFilter(this.html, this.model, item);
    }

    public void clearItemAsButton() {
        ButtonItem item = new ButtonItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.clear"));
        item.setContents(this.messages.getMessage("toolbar.text.clear"));
        ToolbarItemUtils.buildClear(this.html, this.model, item);
    }

    public void clearItemAsImage() {
        ImageItem item = new ImageItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.clear"));
        item.setImage(BuilderUtils.getImage(this.model, "clear"));
        item.setAlt(this.messages.getMessage("toolbar.text.clear"));
        item.setStyle("border:0");
        ToolbarItemUtils.buildClear(this.html, this.model, item);
    }

    public void clearItemAsText() {
        TextItem item = new TextItem();
        item.setTooltip(this.messages.getMessage("toolbar.tooltip.clear"));
        item.setText(this.messages.getMessage("toolbar.text.clear"));
        ToolbarItemUtils.buildClear(this.html, this.model, item);
    }

    public void exportItemAsButton(Export export) {
        ButtonItem item = new ButtonItem();
        item.setTooltip(export.getTooltip());
        item.setContents(export.getText());
        ToolbarItemUtils.buildExport(this.html, this.model, item, export);
    }

    public void exportItemAsImage(Export export) {
        ImageItem item = new ImageItem();
        item.setTooltip(export.getTooltip());
        item.setImage(BuilderUtils.getImage(this.model, export.getImageName()));
        item.setAlt(export.getText());
        item.setStyle("border:0");
        ToolbarItemUtils.buildExport(this.html, this.model, item, export);
    }

    public void exportItemAsText(Export export) {
        TextItem item = new TextItem();
        item.setTooltip(export.getTooltip());
        item.setText(export.getText());
        ToolbarItemUtils.buildExport(this.html, this.model, item, export);
    }

    public void rowsDisplayedDroplist() {
        int rowsDisplayed = this.model.getTableHandler().getTable().getRowsDisplayed();
        int medianRowsDisplayed = this.model.getTableHandler().getTable().getMedianRowsDisplayed();
        int maxRowsDisplayed = this.model.getTableHandler().getTable().getMaxRowsDisplayed();
        int currentRowsDisplayed = this.model.getLimit().getCurrentRowsDisplayed();
        this.html.select().name(this.model.getTableHandler().prefixWithTableId() + "rd");
        StringBuffer onchange = new StringBuffer();
        onchange.append(new TableActions(this.model).getRowsDisplayedAction());
        this.html.onchange(onchange.toString());
        this.html.close();
        this.html.newline();
        this.html.tabs(4);
        this.html.option().value(String.valueOf(rowsDisplayed));
        if (currentRowsDisplayed == rowsDisplayed) {
            this.html.selected();
        }
        this.html.close();
        this.html.append(String.valueOf(rowsDisplayed));
        this.html.optionEnd();
        this.html.option().value(String.valueOf(medianRowsDisplayed));
        if (currentRowsDisplayed == medianRowsDisplayed) {
            this.html.selected();
        }
        this.html.close();
        this.html.append(String.valueOf(medianRowsDisplayed));
        this.html.optionEnd();
        this.html.option().value(String.valueOf(maxRowsDisplayed));
        if (currentRowsDisplayed == maxRowsDisplayed) {
            this.html.selected();
        }
        this.html.close();
        this.html.append(String.valueOf(maxRowsDisplayed));
        this.html.optionEnd();
        this.html.newline();
        this.html.tabs(4);
        this.html.selectEnd();
    }

    public void separator() {
        this.html.img();
        this.html.src(BuilderUtils.getImage(this.model, "separator"));
        this.html.style("border:0");
        this.html.alt("Separator");
        this.html.xclose();
    }

    public String toString() {
        return this.html.toString();
    }
}

