/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.handler;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

public class ColumnHandler {
    private TableModel model;
    private List<Column> columns = new ArrayList<Column>();
    private Column firstColumn;
    private Column lastColumn;

    public ColumnHandler(TableModel model) {
        this.model = model;
    }

    public void addAutoGenerateColumn(Column column) {
        column.addAttribute("isAutoGenerateColumn", "true");
        this.addColumn(column);
    }

    public void addColumn(Column column) {
        column.defaults();
        this.addColumnAttributes(column);
        if (!this.isViewAllowed(column)) {
            return;
        }
        if (this.firstColumn == null) {
            this.firstColumn = column;
            column.setFirstColumn(true);
        }
        if (this.lastColumn != null) {
            this.lastColumn.setLastColumn(false);
        }
        this.lastColumn = column;
        column.setLastColumn(true);
        this.columns.add(column);
    }

    public void addColumnAttributes(Column column) {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, column.getInterceptor(), "column.interceptor.");
        column.setInterceptor(interceptor);
        TableCache.getInstance().getColumnInterceptor(interceptor).addColumnAttributes(this.model, column);
    }

    public void modifyColumnAttributes(Column column) {
        TableCache.getInstance().getColumnInterceptor(column.getInterceptor()).modifyColumnAttributes(this.model, column);
    }

    public int columnCount() {
        return this.columns.size();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Column getColumnByAlias(String alias) {
        for (Column column : this.columns) {
            String columnAlias = column.getAlias();
            if (columnAlias == null || !columnAlias.equals(alias)) continue;
            return column;
        }
        return null;
    }

    public boolean hasMetatData() {
        return this.columnCount() > 0;
    }

    public List<Column> getFilterColumns() {
        boolean cleared = this.model.getLimit().isCleared();
        for (Column column : this.columns) {
            String value = this.model.getLimit().getFilterSet().getFilterValue(column.getAlias());
            if (cleared || StringUtils.isEmpty((CharSequence)value)) {
                value = "";
            }
            Cell cell = TableModelUtils.getFilterCell(column, value);
            column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
        }
        return this.columns;
    }

    public List<Column> getHeaderColumns() {
        for (Column column : this.columns) {
            Cell cell = TableModelUtils.getHeaderCell(column, column.getTitle());
            boolean isExported = this.model.getLimit().isExported();
            if (!isExported) {
                column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
                continue;
            }
            column.setCellDisplay(cell.getExportDisplay(this.model, column));
        }
        return this.columns;
    }

    private boolean isViewAllowed(Column column) {
        String view = this.model.getTableHandler().getTable().getView();
        boolean isExported = this.model.getLimit().isExported();
        if (isExported) {
            view = this.model.getExportHandler().getCurrentExport().getView();
        }
        boolean allowView = this.allowView(column, view);
        boolean denyView = this.denyView(column, view);
        return allowView && !denyView;
    }

    private boolean allowView(Column column, String view) {
        String[] viewsAllowed = column.getViewsAllowed();
        if (viewsAllowed == null || viewsAllowed.length == 0) {
            return true;
        }
        for (int i = 0; i < viewsAllowed.length; ++i) {
            if (!view.equals(viewsAllowed[i])) continue;
            return true;
        }
        return false;
    }

    private boolean denyView(Column column, String view) {
        String[] viewsDenied = column.getViewsDenied();
        if (viewsDenied == null || viewsDenied.length == 0) {
            return false;
        }
        for (int i = 0; i < viewsDenied.length; ++i) {
            if (!view.equals(viewsDenied[i])) continue;
            return true;
        }
        return false;
    }

    public Column getFirstCalcColumn() {
        for (Column column : this.columns) {
            if (!column.isCalculated()) continue;
            return column;
        }
        return null;
    }

    public CalcResult[] getCalcResults(Column column) {
        if (!column.isCalculated()) {
            return new CalcResult[0];
        }
        return CalcUtils.getCalcResults(this.model, column);
    }
}

