/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.HashMap;
import java.util.Map;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Registry;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.state.State;

public abstract class AbstractRegistry
implements Registry {
    protected Map<String, String[]> parameterMap;
    protected Context context;
    protected String tableId;
    protected String prefixWithTableId;
    protected String state;
    protected String stateAttr;
    protected boolean autoIncludeParameters;

    @Override
    public void setParameterMap() {
        HashMap<String, String[]> tableParameterMap = new HashMap<String, String[]>();
        HashMap<String, String[]> userDefinedParameterMap = new HashMap<String, String[]>();
        Map<String, String[]> params = this.context.getParameterMap();
        for (String paramName : params.keySet()) {
            String[] paramValues;
            if (paramName.equals("ec_eti") || paramName.equals("ec_i")) continue;
            if (paramName.startsWith(this.prefixWithTableId + "p") || paramName.startsWith(this.prefixWithTableId + "crd") || paramName.startsWith(this.prefixWithTableId + "s_") || paramName.startsWith(this.prefixWithTableId + "f_") || paramName.startsWith(this.prefixWithTableId + "ev") || paramName.startsWith(this.prefixWithTableId + "efn") || paramName.startsWith(this.prefixWithTableId + "a_") || paramName.startsWith(this.prefixWithTableId + "o_")) {
                paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
                tableParameterMap.put(paramName, paramValues);
                continue;
            }
            if (!this.autoIncludeParameters) continue;
            paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
            userDefinedParameterMap.put(paramName, paramValues);
        }
        this.parameterMap = this.handleState(tableParameterMap);
        this.parameterMap.putAll(userDefinedParameterMap);
    }

    @Override
    public Map<String, String[]> handleState(Map<String, String[]> tableParameterMap) {
        Map<String, String[]> stateParameters;
        State s = TableCache.getInstance().getState(this.state);
        if (tableParameterMap.isEmpty() && (stateParameters = s.getParameters(this.context, this.tableId, this.stateAttr)) != null) {
            tableParameterMap = stateParameters;
        }
        this.handleStateInternal(s, tableParameterMap);
        return tableParameterMap;
    }

    @Override
    public void addParameter(String name, Object value) {
        String[] paramValues = TableModelUtils.getValueAsArray(value);
        this.parameterMap.put(name, paramValues);
    }

    @Override
    public String getParameter(String parameter) {
        String[] values = this.parameterMap.get(parameter);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public void removeParameter(String parameter) {
        this.parameterMap.remove(parameter);
    }

    protected abstract void handleStateInternal(State var1, Map<String, String[]> var2);
}

