/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.callback;

import java.util.Collection;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.callback.FilterRowsCallback;
import org.extremecomponents.table.callback.RetrieveRowsCallback;
import org.extremecomponents.table.callback.SortRowsCallback;
import org.extremecomponents.table.core.RetrievalUtils;
import org.extremecomponents.table.core.TableModel;

public final class LimitCallback
implements RetrieveRowsCallback,
FilterRowsCallback,
SortRowsCallback {
    public static final String TOTAL_ROWS = "totalRows";

    @Override
    public Collection retrieveRows(TableModel model) throws Exception {
        Table table = model.getTableHandler().getTable();
        Collection rows = RetrievalUtils.retrieveCollection(model.getContext(), table.getItems(), table.getScope());
        Object totalRows = RetrievalUtils.retrieve(model.getContext(), TOTAL_ROWS);
        if (totalRows == null) {
            totalRows = (Integer)RetrievalUtils.retrieve(model.getContext(), model.getTableHandler().prefixWithTableId() + TOTAL_ROWS);
        }
        if (!(totalRows instanceof Integer)) {
            String message = "You need to specify the totalRows (as an Integer) to use the " + this.getClass().getName() + ".";
            throw new Exception(message);
        }
        model.getTableHandler().setTotalRows((Integer)totalRows);
        return rows;
    }

    public Collection filterRows(TableModel model, Collection rows) throws Exception {
        return rows;
    }

    @Override
    public Collection sortRows(TableModel model, Collection rows) throws Exception {
        return rows;
    }
}

