/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import com.google.common.collect.Sets;
import java.util.Set;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertexVisitor;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class BusinessServiceVertex
extends AbstractBusinessServiceVertex {
    private final Long serviceId;

    public BusinessServiceVertex(BusinessService businessService, int level) {
        this(businessService.getId(), businessService.getName(), level);
    }

    public BusinessServiceVertex(GraphVertex graphVertex) {
        this(graphVertex.getBusinessService(), graphVertex.getLevel());
    }

    public BusinessServiceVertex(Long serviceId, String name, int level) {
        super((Object)((Object)AbstractBusinessServiceVertex.Type.BusinessService) + ":" + serviceId, name, level);
        this.serviceId = serviceId;
        this.setLabel(name);
        this.setTooltipText(String.format("Business Service '%s'", name));
        this.setIconKey("bsm.business-service");
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    @Override
    public AbstractBusinessServiceVertex.Type getType() {
        return AbstractBusinessServiceVertex.Type.BusinessService;
    }

    @Override
    public Set<String> getReductionKeys() {
        return Sets.newHashSet();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public <T> T accept(BusinessServiceVertexVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

