/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.tcp;

import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.tcp.TcpGroupPersister;
import org.opennms.netmgt.collection.persistence.tcp.TcpOutputStrategy;
import org.opennms.netmgt.collection.persistence.tcp.TcpSinglePersister;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;

public class TcpPersisterFactory
implements PersisterFactory {
    private TcpOutputStrategy m_tcpStrategy;

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return this.createPersister(params, repository, false, false, false);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        if (ResourceTypeUtils.isStoreByGroup() || forceStoreByGroup) {
            return this.createGroupPersister(params, repository, dontPersistCounters);
        }
        return this.createOneToOnePersister(params, repository, dontPersistCounters);
    }

    public Persister createGroupPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters) {
        TcpGroupPersister persister = new TcpGroupPersister(params, repository, this.m_tcpStrategy);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }

    public Persister createOneToOnePersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters) {
        TcpSinglePersister persister = new TcpSinglePersister(params, repository, this.m_tcpStrategy);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }

    public TcpOutputStrategy getTcpStrategy() {
        return this.m_tcpStrategy;
    }

    public void setTcpStrategy(TcpOutputStrategy tcpStrategy) {
        this.m_tcpStrategy = tcpStrategy;
    }
}

