/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.EnumSet;
import java.util.Set;
import org.opennms.features.topology.api.topo.simple.SimpleLeafVertex;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class LinkdVertex
extends SimpleLeafVertex {
    private final Set<ProtocolSupported> m_protocolSupported = EnumSet.noneOf(ProtocolSupported.class);

    public static LinkdVertex create(OnmsTopologyVertex tvertex, String namespace) {
        LinkdVertex vertex = new LinkdVertex(tvertex.getId(), namespace);
        vertex.setNodeID(tvertex.getNodeid());
        vertex.setLabel(tvertex.getLabel());
        vertex.setIpAddress(tvertex.getAddress());
        vertex.setIconKey(tvertex.getIconKey());
        vertex.setTooltipText(tvertex.getToolTipText());
        return vertex;
    }

    public LinkdVertex(String id, String namespace) {
        super(namespace, id, Integer.valueOf(0), Integer.valueOf(0));
    }

    public String getTooltipText() {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append("<p>");
        tooltipText.append(super.getTooltipText());
        tooltipText.append("</p>");
        if (this.m_protocolSupported.size() > 0) {
            tooltipText.append("<p>");
            tooltipText.append(this.m_protocolSupported);
            tooltipText.append("</p>");
        }
        return tooltipText.toString();
    }

    public Set<ProtocolSupported> getProtocolSupported() {
        return this.m_protocolSupported;
    }
}

