/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.commands;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingRequest;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSequence;
import org.opennms.netmgt.icmp.proxy.PingStringUtils;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="opennms", name="ping", description="ICMP Ping")
@Service
public class PingCommand
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(PingCommand.class);
    @Reference
    public LocationAwarePingClient locationAwarePingClient;
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String m_systemId;
    @Option(name="-c", aliases={"--count"}, description="Number of requests")
    int m_count = 1;
    @Argument(index=0, name="host", description="Hostname or IP Address of the system to walk", required=true, multiValued=false)
    String m_host;

    public Object execute() {
        InetAddress byName;
        LOG.debug("opennms:ping {} {}", this.m_location != null ? "-l " + this.m_location : "", (Object)this.m_host);
        try {
            byName = InetAddress.getByName(this.m_host);
        }
        catch (UnknownHostException uhe) {
            System.out.printf("PING %s: Unknown host%n", uhe);
            return null;
        }
        PingRequestBuilder.Callback callback = (newSequence, summary) -> {
            if (this.m_count > 1) {
                if (summary.getSequences().size() == 0) {
                    System.out.println(PingStringUtils.renderHeader((PingSummary)summary));
                }
                if (newSequence != null) {
                    System.out.println(PingStringUtils.renderSequence((PingRequest)summary.getRequest(), (PingSequence)newSequence));
                }
                if (summary.isComplete()) {
                    System.out.println(PingStringUtils.renderSummary((PingSummary)summary));
                }
            }
        };
        CompletableFuture future = this.locationAwarePingClient.ping(byName).withLocation(this.m_location).withSystemId(this.m_systemId).withNumberOfRequests(this.m_count).withProgressCallback(callback).execute();
        while (true) {
            try {
                PingSummary summary2 = (PingSummary)future.get(1L, TimeUnit.SECONDS);
                if (this.m_count != 1) break;
                System.out.println(String.format("PING: %s %.3f ms", byName, summary2.getSequence(0).getResponse().getRtt()));
                break;
            }
            catch (TimeoutException summary2) {
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.m_count != 1) break;
                System.out.println(String.format("PING: %s %s", byName, e.getCause().getClass().getName()));
                break;
            }
            System.out.print(".");
        }
        return null;
    }
}

