/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.opennms.netmgt.model.events.EnableDisableConfSourceEventsPayload;
import org.opennms.netmgt.model.events.EventConfSourceDeletePayload;
import org.opennms.netmgt.model.events.EventConfSrcEnableDisablePayload;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.web.rest.v2.model.AddEventConfSourceRequest;
import org.opennms.web.rest.v2.model.EventConfEventDeletePayload;
import org.opennms.web.rest.v2.model.EventConfEventEditRequest;

@Path(value="eventconf")
@Tag(name="EventConf", description="EventConf API")
public interface EventConfRestApi {
    @POST
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Operation(summary="Upload eventconf files", description="Upload one or more eventconf files including optional eventconf.xml to determine file order.", operationId="uploadEventConfFiles")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Upload successful"), @ApiResponse(responseCode="400", description="Invalid eventconf.xml or request")})
    public Response uploadEventConfFiles(@Multipart(value="upload") List<Attachment> var1, @Context SecurityContext var2) throws Exception;

    @GET
    @Path(value="filter")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Filter EventConf Records", description="Fetch EventConf records based on provided filters such as UEI, vendor, source and name.", operationId="filterEventConf")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConf records retrieved successfully", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request \u2013 invalid or missing input parameters", content={@Content}), @ApiResponse(responseCode="204", description="No matching EventConf records found for the given criteria", content={@Content})})
    public Response filterEventConf(@QueryParam(value="uei") String var1, @QueryParam(value="vendor") String var2, @QueryParam(value="sourceName") String var3, @QueryParam(value="offset") int var4, @QueryParam(value="limit") int var5, @Context SecurityContext var6);

    @PATCH
    @Path(value="/sources/status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Enable/Disable EventConf Sources", description="Enable or disable one or more sources (and optionally cascade to their events)", operationId="enableDisableEventConfSources")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated successfully"), @ApiResponse(responseCode="400", description="Invalid request")})
    public Response enableDisableEventConfSources(EventConfSrcEnableDisablePayload var1, @Context SecurityContext var2) throws Exception;

    @GET
    @Path(value="filter/{sourceId}/events")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get EventConfEvents by Source ID with filtering and sorting", description="Retrieves EventConfEvent records for the given source ID with optional filtering, sorting, and pagination.\n- `eventFilter`: case-insensitive match on UEI, Event Label, or Description.\n- `eventSortBy`: sort field `uei`, `eventLabel`, `description`, `enabled` defaults to `createdTime` if invalid.\n- `eventOrder`: `asc` or `desc` (default: `desc`).\n- `offset` and `limit`: for pagination.", operationId="filterConfEventBySourceId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConf records retrieved successfully", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request \u2013 invalid or missing input parameters", content={@Content}), @ApiResponse(responseCode="204", description="No matching EventConfEvent record found for the given criteria", content={@Content})})
    public Response filterConfEventsBySourceId(@PathParam(value="sourceId") Long var1, @QueryParam(value="eventFilter") String var2, @QueryParam(value="eventSortBy") String var3, @QueryParam(value="eventOrder") String var4, @QueryParam(value="totalRecords") Integer var5, @QueryParam(value="offset") Integer var6, @QueryParam(value="limit") Integer var7, @Context SecurityContext var8);

    @DELETE
    @Path(value="/sources")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete EventConf Sources", description="Delete one or more eventConf sources by their IDs.", operationId="deleteEventConfSources")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Sources deleted successfully"), @ApiResponse(responseCode="400", description="Invalid request (missing/invalid IDs)"), @ApiResponse(responseCode="404", description="One or more sources not found")})
    public Response deleteEventConfSources(EventConfSourceDeletePayload var1, @Context SecurityContext var2) throws Exception;

    @PATCH
    @Path(value="/sources/{sourceId}/events/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update EventConf Sources events", description="Update one or more eventConf sources  by their events IDs.", operationId="enableDisableConfSourcesEvents")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated successfully"), @ApiResponse(responseCode="400", description="Invalid request (missing/invalid IDs)"), @ApiResponse(responseCode="404", description="One or more sources not found")})
    public Response enableDisableEventConfSourcesEvents(@PathParam(value="sourceId") Long var1, EnableDisableConfSourceEventsPayload var2, @Context SecurityContext var3) throws Exception;

    @GET
    @Path(value="filter/sources")
    @Produces(value={"application/json"})
    @Operation(summary="Filter EventConfSource Records", description="Fetch EventConfSource records based on provided filters such as name, vendor, description, fileOrder and eventCount.", operationId="filterEventConfSource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConfSource records retrieved successfully", content={@Content}), @ApiResponse(responseCode="400", description="Bad Request \u2013 invalid or missing input parameters", content={@Content}), @ApiResponse(responseCode="204", description="No matching EventConfSource records found for the given criteria", content={@Content})})
    public Response filterEventConfSource(@QueryParam(value="filter") String var1, @QueryParam(value="sortBy") String var2, @QueryParam(value="order") String var3, @QueryParam(value="totalRecords") Integer var4, @QueryParam(value="offset") Integer var5, @QueryParam(value="limit") Integer var6, @Context SecurityContext var7);

    @GET
    @Path(value="/sources/names")
    @Produces(value={"application/json"})
    @Operation(summary="Get EventConf Source Names", description="Retrieve the names of all EventConf sources stored in the database.", operationId="getEventConfSourcesNames")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved source names"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventConfSourcesNames(@Context SecurityContext var1) throws Exception;

    @POST
    @Path(value="/sources/{sourceId}/events")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json"})
    @Operation(summary="Add a new event to an EventConfSource", description="Creates and adds a new event under the given EventConfSource by its ID.", operationId="addEventConfSourceEvent")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Event created successfully"), @ApiResponse(responseCode="400", description="Invalid request (missing/invalid data)"), @ApiResponse(responseCode="404", description="EventConfSource not found")})
    public Response addEventConfSourceEvent(@PathParam(value="sourceId") Long var1, Event var2, @Context SecurityContext var3) throws Exception;

    @PUT
    @Path(value="/sources/{sourceId}/events/{eventId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json"})
    @Operation(summary="Update EventConf  Event", description="Update  eventConf event by sourceId and eventId.", operationId="updateEventConfEvent")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated successfully"), @ApiResponse(responseCode="400", description="Invalid request"), @ApiResponse(responseCode="404", description="One or more sources not found")})
    public Response updateEventConfEvent(@PathParam(value="sourceId") Long var1, @PathParam(value="eventId") Long var2, EventConfEventEditRequest var3, @Context SecurityContext var4) throws Exception;

    @DELETE
    @Path(value="/sources/{sourceId}/events")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Events for a Source", description="Delete one or more events belonging to the specified eventConf source.", operationId="deleteEventsForSource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Events deleted successfully"), @ApiResponse(responseCode="400", description="Invalid request (missing/invalid event IDs)"), @ApiResponse(responseCode="404", description="Source or one or more events not found")})
    public Response deleteEventsForSource(@PathParam(value="sourceId") Long var1, EventConfEventDeletePayload var2, @Context SecurityContext var3) throws Exception;

    @GET
    @Path(value="/sources/{sourceId}")
    @Produces(value={"application/json"})
    @Operation(summary="Get EventConfSource by ID", description="Retrieve an EventConfSource by its unique identifier.", operationId="getEventConfSourceById")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConfSource retrieved successfully"), @ApiResponse(responseCode="404", description="EventConfSource not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventConfSourceById(@PathParam(value="sourceId") Long var1, @Context SecurityContext var2);

    @GET
    @Path(value="/sources/{sourceId}/events/download")
    @Produces(value={"application/xml"})
    @Operation(summary="Download EventConf XML for a Source", description="    Downloads all EventConf events associated with the specified source ID.\n", operationId="downloadEventConfXmlBySourceId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConf XML downloaded successfully", content={@Content(mediaType="application/xml")}), @ApiResponse(responseCode="400", description="Invalid or missing source ID"), @ApiResponse(responseCode="404", description="No events found for the specified source ID")})
    public Response downloadEventConfXmlBySourceId(@PathParam(value="sourceId") Long var1, @Context SecurityContext var2) throws Exception;

    @GET
    @Path(value="/vendors/{vendorName}/events")
    @Produces(value={"application/json"})
    @Operation(summary="Get EventConf Events by Vendor", description="Returns all EventConf events associated with the specified vendor name.", operationId="getEventsByVendor")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EventConf Events retrieved successfully", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="400", description="Invalid or missing vendor name"), @ApiResponse(responseCode="404", description="No events found for the specified vendor"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventsByVendor(@PathParam(value="vendorName") String var1, @Context SecurityContext var2) throws Exception;

    @POST
    @Path(value="/sources/eventConfSource")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add a new  EventConfSource", description="Creates and adds a new  EventConfSource.", operationId="addEventConfSourceEvent")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="EventConfSource created successfully"), @ApiResponse(responseCode="400", description="Invalid request (missing/invalid data)"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response addEventConfSource(AddEventConfSourceRequest var1, @Context SecurityContext var2) throws Exception;
}

