/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MonitoredServicesComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoredServicesComponent.class);
    @Autowired
    private MonitoredServiceDao m_dao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    public boolean hasStatusChanged(String previousStatus, OnmsMonitoredService targetObject) {
        boolean modified = false;
        String status = targetObject.getStatus();
        LOG.debug("hasStatusChanged: previous status was {}, and new status is {}", (Object)previousStatus, (Object)status);
        if (status != null && previousStatus != null && !previousStatus.equals(status)) {
            modified = true;
            this.m_dao.update((Object)targetObject);
            if ("S".equals(status) || "A".equals(previousStatus) && "F".equals(status)) {
                LOG.debug("hasStatusChanged: suspending polling for service {} on node with IP {}", (Object)targetObject.getServiceName(), (Object)targetObject.getIpAddress().getHostAddress());
                this.sendEvent("uei.opennms.org/nodes/serviceUnmanaged", targetObject);
                this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", targetObject);
            }
            if ("R".equals(status) || "F".equals(previousStatus) && "A".equals(status)) {
                LOG.debug("hasStatusChanged: resuming polling for service {} on node with IP {}", (Object)targetObject.getServiceName(), (Object)targetObject.getIpAddress().getHostAddress());
                this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", targetObject);
            }
        }
        return modified;
    }

    private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
        EventBuilder bldr = new EventBuilder(eventUEI, "ReST");
        bldr.setNodeid((long)dbObj.getNodeId().intValue());
        bldr.setInterface(dbObj.getIpAddress());
        bldr.setService(dbObj.getServiceName());
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }
}

