/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.timeformat.api.TimeformatService;
import org.opennms.netmgt.vmmgr.Controller;
import org.opennms.netmgt.vmmgr.StatusGetter;
import org.opennms.web.rest.v1.InfoDTO;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.rest.v1.config.DatetimeformatConfig;
import org.opennms.web.rest.v1.config.TicketerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="infoRestService")
@Path(value="info")
@Tag(name="Info", description="Info API")
@Transactional
public class InfoRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(InfoRestService.class);
    private static StatusGetter s_statusGetter;
    @Autowired
    TimeformatService timeformatService;

    @GET
    @Produces(value={"application/json"})
    public Response getInfo(@Context HttpServletRequest httpServletRequest) throws ParseException {
        SystemInfoUtils sysInfoUtils = new SystemInfoUtils();
        InfoDTO info = new InfoDTO();
        info.setDisplayVersion(sysInfoUtils.getDisplayVersion());
        info.setVersion(sysInfoUtils.getVersion());
        info.setPackageName(sysInfoUtils.getPackageName());
        info.setPackageDescription(sysInfoUtils.getPackageDescription());
        info.setTicketerConfig(this.getTicketerConfig());
        info.setDatetimeformatConfig(this.getDateformatConfig(httpServletRequest.getSession(false)));
        info.setServices(this.getServices());
        return Response.ok().entity((Object)info).build();
    }

    private DatetimeformatConfig getDateformatConfig(HttpSession session) {
        DatetimeformatConfig config = new DatetimeformatConfig();
        config.setZoneId(this.extractUserTimeZoneId(session));
        config.setDatetimeformat(this.timeformatService.getFormatPattern());
        return config;
    }

    private ZoneId extractUserTimeZoneId(HttpSession session) {
        ZoneId zoneId = null;
        if (session != null) {
            zoneId = (ZoneId)session.getAttribute("org.opennms.ui.timezoneid");
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return zoneId;
    }

    private TicketerConfig getTicketerConfig() {
        TicketerConfig ticketerConfig = new TicketerConfig();
        ticketerConfig.setEnabled("true".equalsIgnoreCase(Vault.getProperty((String)"opennms.alarmTroubleTicketEnabled")));
        if (ticketerConfig.isEnabled()) {
            ticketerConfig.setPlugin(System.getProperty("opennms.ticketer.plugin"));
        }
        return ticketerConfig;
    }

    private Map<String, String> getServices() {
        if (s_statusGetter == null) {
            s_statusGetter = new StatusGetter(new Controller());
        }
        try {
            return s_statusGetter.retrieveStatus();
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to retrieve statuses.  Info will be incomplete.");
            return Collections.emptyMap();
        }
    }

    static void setStatusGetter(StatusGetter getter) {
        s_statusGetter = getter;
    }
}

