/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support.newsfeed;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opennms.web.rest.support.newsfeed.NewsFeed;
import org.opennms.web.rest.support.newsfeed.NewsFeedItem;
import org.opennms.web.rest.support.newsfeed.xml.NewsFeedXml;

public class NewsFeedProvider {
    public NewsFeedXml.RssElement parseXml(InputStream inputStream) throws JAXBException {
        NewsFeedXml.RssElement xRssElem = null;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NewsFeedXml.RssElement.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        xRssElem = (NewsFeedXml.RssElement)jaxbUnmarshaller.unmarshal(inputStream);
        return xRssElem;
    }

    public NewsFeed parseXmlToNewsFeed(NewsFeedXml.RssElement xRssElem) throws Exception {
        NewsFeed newsFeed = new NewsFeed();
        NewsFeedXml.ChannelElement channelElem = xRssElem.getChannelElement();
        newsFeed.channelTitle = channelElem.getTitle();
        ArrayList<NewsFeedItem> items = new ArrayList<NewsFeedItem>();
        for (NewsFeedXml.ItemElement xItem : channelElem.getItems()) {
            NewsFeedItem item = new NewsFeedItem();
            item.title = xItem.getTitle();
            item.description = xItem.getDescription();
            item.shortDescription = this.getShortDescription(xItem.getDescription());
            item.link = xItem.getLink();
            item.setCategories(this.parseCategories(xItem.getCategories()));
            item.setTags(this.parseTags(xItem.getCategories()));
            items.add(item);
        }
        newsFeed.setItems(items);
        return newsFeed;
    }

    private String getShortDescription(String description) {
        int TRUNCATE_LENGTH = 200;
        int pStart = description.indexOf("<p>");
        int pEnd = description.indexOf("</p>");
        String innerText = pStart >= 0 && pEnd > pStart + 3 ? description.substring(pStart + 3, pEnd) : "";
        String shortDescription = innerText.length() > 200 ? innerText.substring(0, 200) + "..." : innerText;
        return shortDescription;
    }

    private List<String> parseCategories(List<String> categories) {
        List<String> cats = categories.stream().filter(x -> x.length() > 0 && Character.isUpperCase(x.charAt(0))).sorted().collect(Collectors.toList());
        return cats;
    }

    private List<String> parseTags(List<String> categories) {
        List<String> tags = categories.stream().filter(x -> x.length() > 0 && Character.isLowerCase(x.charAt(0))).sorted().collect(Collectors.toList());
        return tags;
    }
}

