/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support.menu;

import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.time.CentralizedDateTimeFormat;
import org.opennms.core.time.ExtendedDateOnlyFormat;
import org.opennms.core.time.ExtendedTimeOnlyFormat;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.web.api.Util;
import org.opennms.web.rest.support.menu.MenuRequestContext;

public class HttpMenuRequestContext
implements MenuRequestContext {
    private final HttpServletRequest request;
    private final CentralizedDateTimeFormat dateTimeFormatter = new CentralizedDateTimeFormat();
    private final ExtendedDateOnlyFormat dateOnlyFormatter = new ExtendedDateOnlyFormat();
    private final ExtendedTimeOnlyFormat timeOnlyFormatter = new ExtendedTimeOnlyFormat();

    public HttpMenuRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    @Override
    public String calculateUrlBase() {
        return Util.calculateUrlBase((HttpServletRequest)this.request);
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public boolean isUserInAnyRole(List<String> roles) {
        return roles.stream().anyMatch(arg_0 -> ((HttpServletRequest)this.request).isUserInRole(arg_0));
    }

    @Override
    public String getFormattedDateTime() {
        return this.dateTimeFormatter.format(Instant.now(), this.extractUserTimeZone());
    }

    @Override
    public String getFormattedDate() {
        return this.dateOnlyFormatter.format(Instant.now(), this.extractUserTimeZone());
    }

    @Override
    public String getFormattedTime() {
        return this.timeOnlyFormatter.format(Instant.now(), this.extractUserTimeZone());
    }

    @Override
    public String getNoticeStatus() {
        try {
            return NotifdConfigFactory.getPrettyStatus();
        }
        catch (Throwable throwable) {
            return "Unknown";
        }
    }

    @Override
    public String getSystemProperty(String name, String def) {
        return System.getProperty(name, def);
    }

    private ZoneId extractUserTimeZone() {
        ZoneId timeZoneId = (ZoneId)this.request.getSession().getAttribute("org.opennms.ui.timezoneid");
        if (timeZoneId == null) {
            timeZoneId = ZoneId.systemDefault();
        }
        return timeZoneId;
    }
}

