/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.AbstractTimeIntervalSequence;
import org.opennms.core.utils.OwnedInterval;
import org.opennms.core.utils.OwnedIntervalSequence;
import org.opennms.core.utils.Owner;
import org.opennms.core.utils.TimeInterval;
import org.opennms.netmgt.config.BasicSchedule;
import org.opennms.netmgt.config.Time;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicScheduleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BasicScheduleUtils.class);
    private static final Pattern SPECIFIC_DATE_PATTERN = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d|\\d\\d-...-\\d\\d\\d\\d) .*$");
    protected static final ThreadLocal<Map<String, Integer>> m_dayOfWeekMap = new ThreadLocal<Map<String, Integer>>(){

        @Override
        protected Map<String, Integer> initialValue() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("sunday", 1);
            map.put("monday", 2);
            map.put("tuesday", 3);
            map.put("wednesday", 4);
            map.put("thursday", 5);
            map.put("friday", 6);
            map.put("saturday", 7);
            return map;
        }
    };
    public static final String FORMAT1 = "dd-MMM-yyyy HH:mm:ss";
    public static final String FORMAT2 = "HH:mm:ss";

    public static boolean isTimeInSchedule(Calendar cal, BasicSchedule sched) {
        if (cal == null) {
            LOG.warn("isTimeInOutage: calendar is null");
            return false;
        }
        if (sched == null) {
            LOG.warn("isTimeInOutage: schedule is null");
            return false;
        }
        LOG.debug("isTimeInOutage: checking for time '{}' in schedule '{}'", (Object)cal.getTime(), (Object)sched.getName());
        GregorianCalendar outCalBegin = new GregorianCalendar();
        GregorianCalendar outCalEnd = new GregorianCalendar();
        long curCalTime = cal.getTimeInMillis();
        boolean inOutage = false;
        Enumeration<Time> e = sched.enumerateTime();
        while (e.hasMoreElements() && !inOutage) {
            outCalBegin.setTimeInMillis(curCalTime);
            outCalEnd.setTimeInMillis(curCalTime);
            Time oTime = e.nextElement();
            String oTimeDay = oTime.getDay().orElse(null);
            String begins = oTime.getBegins();
            String ends = oTime.getEnds();
            if (oTimeDay != null) {
                Integer dayInMap = BasicScheduleUtils.getDayOfWeekIndex(oTimeDay);
                if (dayInMap != null) {
                    if (cal.get(7) == dayInMap.intValue()) {
                        inOutage = true;
                    }
                    outCalBegin.set(7, dayInMap);
                    outCalEnd.set(7, dayInMap);
                } else {
                    int intOTimeDay = Integer.valueOf(oTimeDay);
                    if (cal.get(5) == intOTimeDay) {
                        inOutage = true;
                    }
                    outCalBegin.set(5, intOTimeDay);
                    outCalEnd.set(5, intOTimeDay);
                }
            }
            if (oTimeDay != null && !inOutage) continue;
            BasicScheduleUtils.setOutCalTime(outCalBegin, begins);
            BasicScheduleUtils.setOutCalTime(outCalEnd, ends);
            LOG.debug("isTimeInOutage: checking begin/end time...\n current: {}\n begin: {}\n end: {}", new Object[]{cal.getTime(), outCalBegin.getTime(), outCalEnd.getTime()});
            long outCalBeginTime = outCalBegin.getTimeInMillis() / 1000L * 1000L;
            long outCalEndTime = (outCalEnd.getTimeInMillis() / 1000L + 1L) * 1000L;
            if (curCalTime >= outCalBeginTime && curCalTime < outCalEndTime) {
                inOutage = true;
                continue;
            }
            inOutage = false;
        }
        return inOutage;
    }

    public static void setOutCalTime(Calendar outCal, String timeStr) {
        if (timeStr.length() == FORMAT1.length()) {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT1);
            Date tempDate = null;
            try {
                tempDate = format.parse(timeStr);
            }
            catch (ParseException pE) {
                tempDate = null;
            }
            if (tempDate == null) {
                return;
            }
            GregorianCalendar tempCal = new GregorianCalendar();
            tempCal.setTime(tempDate);
            outCal.set(1, tempCal.get(1));
            outCal.set(2, tempCal.get(2));
            outCal.set(5, tempCal.get(5));
            outCal.set(11, tempCal.get(11));
            outCal.set(12, tempCal.get(12));
            outCal.set(13, tempCal.get(13));
            outCal.set(14, 0);
        } else if (timeStr.length() == FORMAT2.length()) {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT2);
            Date tempDate = null;
            try {
                tempDate = format.parse(timeStr);
            }
            catch (ParseException pE) {
                tempDate = null;
            }
            if (tempDate == null) {
                return;
            }
            GregorianCalendar tempCal = new GregorianCalendar();
            tempCal.setTime(tempDate);
            outCal.set(11, tempCal.get(11));
            outCal.set(12, tempCal.get(12));
            outCal.set(13, tempCal.get(13));
            outCal.set(14, 0);
        }
    }

    public static Integer getDayOfWeekIndex(String dayName) {
        if (dayName == null) {
            return null;
        }
        return m_dayOfWeekMap.get().get(dayName.toLowerCase());
    }

    public static Calendar getEndOfSchedule(BasicSchedule out) {
        long curCalTime = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(curCalTime);
        boolean inOutage = false;
        Enumeration<Time> en = out.enumerateTime();
        while (en.hasMoreElements() && !inOutage) {
            GregorianCalendar outCalBegin = new GregorianCalendar();
            GregorianCalendar outCalEnd = new GregorianCalendar();
            Time oTime = en.nextElement();
            String oTimeDay = oTime.getDay().orElse(null);
            String begins = oTime.getBegins();
            String ends = oTime.getEnds();
            if (oTime.getDay().isPresent()) {
                Integer dayInMap = BasicScheduleUtils.getDayOfWeekIndex(oTimeDay);
                if (dayInMap != null) {
                    if (cal.get(7) == dayInMap.intValue()) {
                        inOutage = true;
                    }
                    outCalBegin.set(7, dayInMap);
                    outCalEnd.set(7, dayInMap);
                } else {
                    int intOTimeDay = Integer.valueOf(oTimeDay);
                    if (cal.get(5) == intOTimeDay) {
                        inOutage = true;
                    }
                    outCalBegin.set(5, intOTimeDay);
                    outCalEnd.set(5, intOTimeDay);
                }
            }
            if (oTimeDay != null && !inOutage) continue;
            BasicScheduleUtils.setOutCalTime(outCalBegin, begins);
            BasicScheduleUtils.setOutCalTime(outCalEnd, ends);
            long outCalBeginTime = outCalBegin.getTime().getTime() / 1000L * 1000L;
            long outCalEndTime = (outCalEnd.getTime().getTime() / 1000L + 1L) * 1000L;
            if (curCalTime < outCalBeginTime || curCalTime >= outCalEndTime) continue;
            return outCalEnd;
        }
        return null;
    }

    public static boolean isTimeInSchedule(Date time, BasicSchedule sched) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return BasicScheduleUtils.isTimeInSchedule(cal, sched);
    }

    public static boolean isDaily(Time time) {
        return !time.getDay().isPresent() && !BasicScheduleUtils.isSpecific(time);
    }

    public static boolean isWeekly(Time time) {
        return BasicScheduleUtils.getDayOfWeekIndex(time.getDay().orElse(null)) != null;
    }

    public static boolean isMonthly(Time time) {
        return time.getDay().isPresent() && BasicScheduleUtils.getDayOfWeekIndex(time.getDay().get()) == null;
    }

    public static boolean isSpecific(Time time) {
        if (!time.getDay().isPresent()) {
            return SPECIFIC_DATE_PATTERN.matcher(time.getBegins()).matches();
        }
        return false;
    }

    public static Date getSpecificTime(String specificString) {
        Calendar cal = Calendar.getInstance();
        BasicScheduleUtils.setOutCalTime(cal, specificString);
        return cal.getTime();
    }

    public static Date getMonthlyTime(Date referenceTime, String day, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        ref.set(5, Integer.parseInt(day));
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static Date getWeeklyTime(Date referenceTime, String day, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        ref.set(7, BasicScheduleUtils.getDayOfWeekIndex(day));
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static Date getDailyTime(Date referenceTime, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static OwnedInterval getInterval(Date ref, Time time, Owner owner) {
        String begins = time.getBegins();
        String ends = time.getEnds();
        String day = time.getDay().orElse(null);
        if (BasicScheduleUtils.isWeekly(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getWeeklyTime(ref, day, begins), BasicScheduleUtils.getWeeklyTime(ref, day, ends));
        }
        if (BasicScheduleUtils.isMonthly(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getMonthlyTime(ref, day, begins), BasicScheduleUtils.getMonthlyTime(ref, day, ends));
        }
        if (BasicScheduleUtils.isDaily(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getDailyTime(ref, begins), BasicScheduleUtils.getDailyTime(ref, ends));
        }
        return new OwnedInterval(owner, BasicScheduleUtils.getSpecificTime(begins), BasicScheduleUtils.getSpecificTime(ends));
    }

    public static Date nextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date nextWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 7);
        return cal.getTime();
    }

    public static Date nextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        return cal.getTime();
    }

    public static OwnedIntervalSequence getIntervals(Date start, Date end, Time time, Owner owner) {
        OwnedIntervalSequence seq = new OwnedIntervalSequence();
        if (time.getBegins().equals(time.getEnds())) {
            return seq;
        }
        if (BasicScheduleUtils.isWeekly(time)) {
            Date done = BasicScheduleUtils.nextWeek(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval((TimeInterval)BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextWeek(ref);
            }
        } else if (BasicScheduleUtils.isMonthly(time)) {
            Date done = BasicScheduleUtils.nextMonth(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval((TimeInterval)BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextMonth(ref);
            }
        } else if (BasicScheduleUtils.isDaily(time)) {
            Date done = BasicScheduleUtils.nextDay(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval((TimeInterval)BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextDay(ref);
            }
        } else {
            seq.addInterval((TimeInterval)BasicScheduleUtils.getInterval(start, time, owner));
        }
        seq.bound(start, end);
        return seq;
    }

    public static OwnedIntervalSequence getIntervals(TimeInterval interval, Time time, Owner owner) {
        return BasicScheduleUtils.getIntervals(interval.getStart(), interval.getEnd(), time, owner);
    }

    public static OwnedIntervalSequence getIntervalsCovering(Date start, Date end, BasicSchedule sched, Owner owner) {
        OwnedIntervalSequence seq = new OwnedIntervalSequence();
        for (int i = 0; i < sched.getTimeCount(); ++i) {
            Time time = sched.getTime(i);
            Owner thisOwner = owner.addTimeIndex(i);
            seq.addAll((AbstractTimeIntervalSequence)BasicScheduleUtils.getIntervals(start, end, time, thisOwner));
        }
        return seq;
    }

    public static OwnedIntervalSequence getIntervalsCovering(TimeInterval interval, BasicSchedule sched, Owner owner) {
        return BasicScheduleUtils.getIntervalsCovering(interval.getStart(), interval.getEnd(), sched, owner);
    }

    public static BasicSchedule getBasicOutageSchedule(Outage out) {
        if (out == null) {
            return null;
        }
        BasicSchedule schedule = new BasicSchedule();
        schedule.setName(out.getName());
        schedule.setType(out.getType());
        ArrayList<Time> times = new ArrayList<Time>();
        for (org.opennms.netmgt.config.poller.outages.Time time : out.getTimes()) {
            times.add(new Time(time.getId().orElse(null), time.getDay().orElse(null), time.getBegins(), time.getEnds()));
        }
        schedule.setTimeCollection(times);
        return schedule;
    }

    public static BasicSchedule getGroupSchedule(Schedule schedule) {
        if (schedule == null) {
            return null;
        }
        BasicSchedule basicSchedule = new BasicSchedule();
        basicSchedule.setName(schedule.getName());
        basicSchedule.setType(schedule.getType());
        ArrayList<Time> times = new ArrayList<Time>();
        for (org.opennms.netmgt.config.groups.Time time : schedule.getTimes()) {
            times.add(new Time(time.getId().orElse(null), time.getDay().orElse(null), time.getBegins(), time.getEnds()));
        }
        basicSchedule.setTimeCollection(times);
        return basicSchedule;
    }
}

