/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.UpdatePacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerHeader;

public class RouteMonitoringPacket
implements Packet {
    public final Header header;
    public final PeerHeader peerHeader;
    public final Optional<UpdatePacket> updateMessage;

    public RouteMonitoringPacket(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        this.header = Objects.requireNonNull(header);
        this.peerHeader = new PeerHeader(buffer);
        this.updateMessage = UpdatePacket.parse(buffer, this.peerHeader.flags, peerAccessor.getPeerInfo(this.peerHeader));
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <R> R map(Packet.Mapper<R> mapper) {
        return mapper.map(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("peerHeader", (Object)this.peerHeader).add("updateMessage", this.updateMessage).toString();
    }
}

