/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;

public class MUCAdmin
extends IQ {
    private List<Item> items = new ArrayList<Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"http://jabber.org/protocol/muc#admin\">");
        List<Item> list = this.items;
        synchronized (list) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                buf.append(item.toXML());
            }
        }
        buf.append(this.getExtensionsXML());
        buf.append("</query>");
        return buf.toString();
    }

    public static class Item {
        private String actor;
        private String reason;
        private String affiliation;
        private String jid;
        private String nick;
        private String role;

        public Item(String affiliation, String role) {
            this.affiliation = affiliation;
            this.role = role;
        }

        public String getActor() {
            return this.actor;
        }

        public String getReason() {
            return this.reason;
        }

        public String getAffiliation() {
            return this.affiliation;
        }

        public String getJid() {
            return this.jid;
        }

        public String getNick() {
            return this.nick;
        }

        public String getRole() {
            return this.role;
        }

        public void setActor(String actor) {
            this.actor = actor;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item");
            if (this.getAffiliation() != null) {
                buf.append(" affiliation=\"").append(this.getAffiliation()).append("\"");
            }
            if (this.getJid() != null) {
                buf.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNick() != null) {
                buf.append(" nick=\"").append(this.getNick()).append("\"");
            }
            if (this.getRole() != null) {
                buf.append(" role=\"").append(this.getRole()).append("\"");
            }
            if (this.getReason() == null && this.getActor() == null) {
                buf.append("/>");
            } else {
                buf.append(">");
                if (this.getReason() != null) {
                    buf.append("<reason>").append(this.getReason()).append("</reason>");
                }
                if (this.getActor() != null) {
                    buf.append("<actor jid=\"").append(this.getActor()).append("\"/>");
                }
                buf.append("</item>");
            }
            return buf.toString();
        }
    }
}

