/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.repository.global;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opennms.features.reporting.dao.remoterepository.RemoteRepositoryConfigDao;
import org.opennms.features.reporting.model.basicreport.BasicReportDefinition;
import org.opennms.features.reporting.model.remoterepository.RemoteRepositoryDefinition;
import org.opennms.features.reporting.repository.ReportRepository;
import org.opennms.features.reporting.repository.global.GlobalReportRepository;
import org.opennms.features.reporting.repository.remote.DefaultRemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultGlobalReportRepository
implements GlobalReportRepository {
    private final Logger logger = LoggerFactory.getLogger(DefaultGlobalReportRepository.class);
    private RemoteRepositoryConfigDao m_remoteRepositoryConfigDao;
    private ReportRepository m_localReportRepository;
    private static final String REPOSITORY_REPORT_SEP = "_";
    private final List<ReportRepository> m_repositoryList;
    private String m_jasperReportVersion;

    public DefaultGlobalReportRepository(RemoteRepositoryConfigDao remoteRepositoryConfigDao, ReportRepository localReportRepository) {
        this.m_remoteRepositoryConfigDao = remoteRepositoryConfigDao;
        this.m_localReportRepository = localReportRepository;
        this.m_jasperReportVersion = System.getProperty("org.opennms.jasperReportsVersion");
        this.m_repositoryList = new ArrayList<ReportRepository>();
        try {
            this.logger.debug("Config resource is set to '{}'", (Object)this.m_remoteRepositoryConfigDao.toString());
            Assert.notNull((Object)this.m_remoteRepositoryConfigDao, (String)"remote repository config dao property configResource must be set to a non-null value");
            this.logger.debug("Local report repository is set to '{}'", (Object)this.m_localReportRepository.toString());
            Assert.notNull((Object)this.m_localReportRepository, (String)"local report repository property must be set to a non-null value");
        }
        catch (Exception e) {
            this.logger.error("Error during create a default global report repository. Error message: '{}'", (Object)e.getMessage());
        }
        try {
            this.logger.debug("JasperReports version is set to '{}'", (Object)this.m_jasperReportVersion);
            Assert.notNull((Object)this.m_jasperReportVersion, (String)"jasper report version must be set to a non-null value");
        }
        catch (Exception e) {
            this.logger.error("Jasper report version must be set in opennms.properties. Error message: '{}'", (Object)e.getMessage());
        }
        this.setRemoteRepositoryConfigDao(remoteRepositoryConfigDao);
    }

    @Override
    public List<BasicReportDefinition> getAllReports() {
        ArrayList<BasicReportDefinition> results = new ArrayList<BasicReportDefinition>();
        for (ReportRepository repository : this.m_repositoryList) {
            results.addAll(repository.getReports());
        }
        this.logger.debug("getAllReports was called result: '{}'", results);
        return results;
    }

    @Override
    public List<BasicReportDefinition> getReports(String repositoryId) {
        ArrayList<BasicReportDefinition> results = new ArrayList<BasicReportDefinition>();
        ReportRepository repository = this.getRepositoryById(repositoryId);
        if (repository != null) {
            results.addAll(repository.getReports());
        }
        this.logger.debug("getReports was called for: '{}' result: '{}'", (Object)repositoryId, results);
        return results;
    }

    @Override
    public List<BasicReportDefinition> getAllOnlineReports() {
        ArrayList<BasicReportDefinition> results = new ArrayList<BasicReportDefinition>();
        for (ReportRepository repository : this.m_repositoryList) {
            results.addAll(repository.getOnlineReports());
        }
        this.logger.debug("getAllOnlineReports was called result: '{}'", results);
        return results;
    }

    @Override
    public List<BasicReportDefinition> getOnlineReports(String repositoryId) {
        ArrayList<BasicReportDefinition> results = new ArrayList<BasicReportDefinition>();
        ReportRepository repository = this.getRepositoryById(repositoryId);
        if (repository != null) {
            results.addAll(repository.getOnlineReports());
        }
        this.logger.debug("getOnlineReports was called for: '{}' result: '{}'", (Object)repositoryId, results);
        return results;
    }

    @Override
    public String getReportService(String reportId) {
        String result = "";
        ReportRepository repository = this.getRepositoryForReport(reportId);
        if (repository != null) {
            result = repository.getReportService(reportId);
        }
        this.logger.debug("getReportService was called for: '{}' result: '{}'", (Object)reportId, (Object)result);
        return result;
    }

    @Override
    public String getDisplayName(String reportId) {
        String result = "";
        ReportRepository repository = this.getRepositoryForReport(reportId);
        if (repository != null) {
            result = repository.getDisplayName(reportId);
        }
        this.logger.debug("getDisplayName was called for: '{}' result: '{}'", (Object)reportId, (Object)result);
        return result;
    }

    @Override
    public String getEngine(String reportId) {
        String result = "";
        ReportRepository repository = this.getRepositoryForReport(reportId);
        if (repository != null) {
            result = repository.getEngine(reportId);
        }
        this.logger.debug("getEngine was called for: '{}' result: '{}'", (Object)reportId, (Object)result);
        return result;
    }

    @Override
    public InputStream getTemplateStream(String reportId) {
        InputStream templateStream = null;
        ReportRepository repository = this.getRepositoryForReport(reportId);
        if (repository != null) {
            templateStream = repository.getTemplateStream(reportId);
        }
        this.logger.debug("getTemplateStream was called for: '{}' result: '{}'", (Object)reportId, (Object)templateStream);
        return templateStream;
    }

    @Override
    public List<ReportRepository> getRepositoryList() {
        this.logger.debug("getRepositoryList was called, result: '{}'", this.m_repositoryList);
        return this.m_repositoryList;
    }

    @Override
    public void addReportRepository(ReportRepository repository) {
        this.logger.debug("addReportRepository was called for: '{}'", (Object)repository);
        this.m_repositoryList.add(repository);
    }

    @Override
    public ReportRepository getRepositoryById(String repositoryId) {
        for (ReportRepository repository : this.m_repositoryList) {
            if (!repositoryId.equals(repository.getRepositoryId())) continue;
            this.logger.debug("getRepositoryById was called for: '{}' result: '{}'", (Object)repositoryId, (Object)repository);
            return repository;
        }
        this.logger.debug("getRepositoryById was called for: '{}' result: '{}'", (Object)repositoryId, null);
        return null;
    }

    protected ReportRepository getRepositoryForReport(String reportId) {
        int idx = reportId.indexOf(REPOSITORY_REPORT_SEP);
        String repositoryId = idx > -1 ? reportId.substring(0, idx) : "local";
        this.logger.debug("getRepositoryForReport was called for: '{}' result repository: '{}'", (Object)reportId, (Object)repositoryId);
        return this.getRepositoryById(repositoryId);
    }

    public void setLocalReportRepository(ReportRepository reportRepository) {
        this.m_localReportRepository = reportRepository;
    }

    public ReportRepository getReportRepository() {
        return this.m_localReportRepository;
    }

    public void setRemoteRepositoryConfigDao(RemoteRepositoryConfigDao remoteRepositoryConfigDao) {
        this.m_remoteRepositoryConfigDao = remoteRepositoryConfigDao;
        this.m_repositoryList.clear();
        this.m_repositoryList.add(this.m_localReportRepository);
        try {
            for (RemoteRepositoryDefinition repositoryDefinition : this.m_remoteRepositoryConfigDao.getActiveRepositories()) {
                this.m_repositoryList.add(new DefaultRemoteRepository(repositoryDefinition, this.m_jasperReportVersion));
            }
        }
        catch (Exception e) {
            this.logger.error("Could not add configured remote repositories in default global report repository. Error message: '{}'", (Object)e.getMessage());
        }
    }

    public RemoteRepositoryConfigDao getRemoteRepositoryConfigDao() {
        return this.m_remoteRepositoryConfigDao;
    }

    @Override
    public void reloadConfigurationFiles() {
        try {
            this.m_remoteRepositoryConfigDao.loadConfiguration();
            this.setRemoteRepositoryConfigDao(this.m_remoteRepositoryConfigDao);
            this.m_localReportRepository.loadConfiguration();
        }
        catch (Exception e) {
            this.logger.error("Could not reload configuration on repositories: '{}'", (Object)e.getMessage());
        }
    }
}

