/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.requisition.command;

import com.google.common.primitives.Booleans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.RegExpRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.SnmpMetadataException;
import org.opennms.netmgt.provision.SnmpMetadataProvisioningAdapter;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

@Command(scope="opennms", name="snmp-metadata-provisioning-adapter", description="Trigger SnmpMetadataProvisioningAdapter for a set of nodes")
@Service
public class SnmpMetadataProvisioningAdapterCommand
implements Action {
    @Reference
    public TransactionOperations transactionOperations;
    @Reference
    private NodeDao nodeDao;
    @Reference
    Terminal terminal;
    @Option(name="-i", aliases={"--id"}, description="Node Id to process", required=false, multiValued=false)
    Integer id;
    @Option(name="-a", aliases={"--all"}, description="Process all nodes", required=false, multiValued=false)
    Boolean all;
    @Option(name="-r", aliases={"--regexp"}, description="Process nodes by label (regular expression)", required=false, multiValued=false)
    String regexp;
    @Option(name="-p", aliases={"--persist"}, description="Persist data instead of displaying it", required=false, multiValued=false)
    Boolean persist = false;

    public Object execute() {
        int optionsSet = Booleans.countTrue((boolean[])new boolean[]{this.id != null, this.regexp != null, this.all != null});
        if (optionsSet == 0) {
            System.out.println("Please provide one of the options --id/-i, --all/-a or --regexp/-r");
        } else if (optionsSet > 1) {
            System.out.println("Please provide only one option (--id, --all, --regexp)");
        } else {
            this.transactionOperations.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(TransactionStatus transactionStatus) {
                    ArrayList<OnmsNode> onmsNodes = new ArrayList<OnmsNode>();
                    if (SnmpMetadataProvisioningAdapterCommand.this.all != null) {
                        onmsNodes.addAll(SnmpMetadataProvisioningAdapterCommand.this.nodeDao.findAll());
                    }
                    if (SnmpMetadataProvisioningAdapterCommand.this.regexp != null) {
                        Criteria criteria = new Criteria(OnmsNode.class);
                        criteria.addRestriction((Restriction)new RegExpRestriction("label", (Object)SnmpMetadataProvisioningAdapterCommand.this.regexp));
                        onmsNodes.addAll(SnmpMetadataProvisioningAdapterCommand.this.nodeDao.findMatching(criteria));
                    }
                    if (SnmpMetadataProvisioningAdapterCommand.this.id != null) {
                        onmsNodes.add((OnmsNode)SnmpMetadataProvisioningAdapterCommand.this.nodeDao.get((Serializable)SnmpMetadataProvisioningAdapterCommand.this.id));
                    }
                    SnmpMetadataProvisioningAdapterCommand.this.processNodes(onmsNodes, SnmpMetadataProvisioningAdapterCommand.this.persist);
                    return null;
                }
            });
        }
        return null;
    }

    private void processNodes(List<OnmsNode> onmsNodes, boolean persist) {
        SnmpMetadataProvisioningAdapter snmpMetadataProvisioningAdapter = (SnmpMetadataProvisioningAdapter)BeanUtils.getBean((String)"provisiondContext", (String)"snmpMetadataProvisioningAdapter", SnmpMetadataProvisioningAdapter.class);
        System.out.println("Processing " + onmsNodes.size() + " node(s)...");
        for (OnmsNode onmsNode : onmsNodes) {
            List results;
            System.out.printf("\nProcessing node '%s' (id=%d)...\n", onmsNode.getLabel(), onmsNode.getId());
            if (onmsNode == null) {
                System.out.println("Error: node is null.");
                continue;
            }
            OnmsIpInterface onmsIpInterface = onmsNode.getPrimaryInterface();
            if (onmsIpInterface == null) {
                System.out.println("Error: primary interface is null.");
                continue;
            }
            try {
                if (persist) {
                    System.out.printf("Calling SnmpMetadataProvisioingAdapter.doUpdateNode(%d)...\n", onmsNode.getId());
                    snmpMetadataProvisioningAdapter.doUpdateNode(onmsNode.getId().intValue());
                    continue;
                }
                results = snmpMetadataProvisioningAdapter.createMetadata(onmsNode, onmsNode.getPrimaryInterface());
            }
            catch (SnmpMetadataException e) {
                System.out.println("Error: provisioning adapter threw exception");
                e.printStackTrace(System.out);
                continue;
            }
            if (results == null) {
                System.out.println("Error: node don't support SNMP (provisioning adapter returned null).");
                continue;
            }
            if (results.size() == 0) {
                System.out.println("Provisioning adapter returned no data.");
                continue;
            }
            System.out.printf("Provisioning adapter returned %d metadata entries.\n\n", results.size());
            ShellTable table = new ShellTable();
            table.size(this.terminal.getWidth() - 1);
            table.column("Context");
            table.column("Key");
            table.column("Value");
            for (OnmsMetaData onmsMetaData : results) {
                table.addRow().addContent(new Object[]{onmsMetaData.getContext(), onmsMetaData.getKey(), onmsMetaData.getValue()});
            }
            table.print(System.out);
        }
    }
}

