/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByte2FloatMap;
import it.unimi.dsi.fastutil.bytes.AbstractByte2FloatSortedMap;
import it.unimi.dsi.fastutil.bytes.AbstractByteSortedSet;
import it.unimi.dsi.fastutil.bytes.Byte2FloatMap;
import it.unimi.dsi.fastutil.bytes.Byte2FloatSortedMap;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteSortedSet;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Byte2FloatLinkedOpenHashMap
extends AbstractByte2FloatSortedMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient byte[] key;
    protected transient float[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Byte2FloatSortedMap.FastSortedEntrySet entries;
    protected volatile transient ByteSortedSet keys;
    protected volatile transient FloatCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;

    public Byte2FloatLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new byte[this.n];
        this.value = new float[this.n];
        this.used = new boolean[this.n];
        this.link = new long[this.n];
    }

    public Byte2FloatLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Byte2FloatLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Byte2FloatLinkedOpenHashMap(Map<? extends Byte, ? extends Float> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2FloatLinkedOpenHashMap(Map<? extends Byte, ? extends Float> m) {
        this(m, 0.75f);
    }

    public Byte2FloatLinkedOpenHashMap(Byte2FloatMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Byte2FloatLinkedOpenHashMap(Byte2FloatMap m) {
        this(m, 0.75f);
    }

    public Byte2FloatLinkedOpenHashMap(byte[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Byte2FloatLinkedOpenHashMap(byte[] k, float[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public float put(byte k, float v) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                float oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Float put(Byte ok, Float ov) {
        float v = ov.floatValue();
        byte k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Float oldValue = Float.valueOf(this.value[pos]);
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public float add(byte k, float incr) {
        return this.addTo(k, incr);
    }

    public float addTo(byte k, float incr) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                float oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos] ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public float remove(byte k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                float v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Float remove(Object ok) {
        byte k = (Byte)ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                float v = this.value[pos];
                this.shiftKeys(pos);
                return Float.valueOf(v);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public float removeFirstFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.first;
        this.first = (int)this.link[pos];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        float v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public float removeLastFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.last;
        this.last = (int)(this.link[pos] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        float v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public float getAndMoveToFirst(byte k) {
        byte[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToFirst(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public float getAndMoveToLast(byte k) {
        byte[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToLast(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public float putAndMoveToFirst(byte k, float v) {
        byte[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                float oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToFirst(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public float putAndMoveToLast(byte k, float v) {
        byte[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                float oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToLast(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public Float get(Byte ok) {
        byte k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return Float.valueOf(this.value[pos]);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public float get(byte k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(byte k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(float v) {
        float[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public byte firstByteKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public byte lastByteKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ByteComparator comparator() {
        return null;
    }

    @Override
    public Byte2FloatSortedMap tailMap(byte from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2FloatSortedMap headMap(byte to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte2FloatSortedMap subMap(byte from, byte to) {
        throw new UnsupportedOperationException();
    }

    public Byte2FloatSortedMap.FastSortedEntrySet byte2FloatEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ByteSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public FloatCollection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                @Override
                public FloatIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Byte2FloatLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(float v) {
                    return Byte2FloatLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Byte2FloatLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        byte[] key = this.key;
        float[] value = this.value;
        int mask = newN - 1;
        byte[] newKey = new byte[newN];
        float[] newValue = new float[newN];
        boolean[] newUsed = new boolean[newN];
        long[] link = this.link;
        long[] newLink = new long[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            byte k = key[i];
            int pos = HashCommon.murmurHash3(k ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLink[n2] = newLink[n2] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
    }

    public Byte2FloatLinkedOpenHashMap clone() {
        Byte2FloatLinkedOpenHashMap c;
        try {
            c = (Byte2FloatLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (byte[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= HashCommon.float2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        byte[] key = this.key;
        float[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeByte(key[e]);
            s.writeFloat(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new byte[this.n];
        byte[] key = this.key;
        this.value = new float[this.n];
        float[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new long[this.n];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            byte k = s.readByte();
            float v = s.readFloat();
            pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                link[n2] = link[n2] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n = pos;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatListIterator {
        @Override
        public float previousFloat() {
            return Byte2FloatLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Float previous() {
            return Float.valueOf(Byte2FloatLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        @Override
        public void set(Float ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Float ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float nextFloat() {
            return Byte2FloatLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Byte2FloatLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractByteSortedSet {
        private KeySet() {
        }

        @Override
        public ByteListIterator iterator(byte from) {
            return new KeyIterator(from);
        }

        @Override
        public ByteListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Byte2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(byte k) {
            return Byte2FloatLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(byte k) {
            int oldSize = Byte2FloatLinkedOpenHashMap.this.size;
            Byte2FloatLinkedOpenHashMap.this.remove(k);
            return Byte2FloatLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Byte2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public byte firstByte() {
            if (Byte2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Byte2FloatLinkedOpenHashMap.this.key[Byte2FloatLinkedOpenHashMap.this.first];
        }

        @Override
        public byte lastByte() {
            if (Byte2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Byte2FloatLinkedOpenHashMap.this.key[Byte2FloatLinkedOpenHashMap.this.last];
        }

        @Override
        public ByteComparator comparator() {
            return null;
        }

        @Override
        public final ByteSortedSet tailSet(byte from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ByteSortedSet headSet(byte to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ByteSortedSet subSet(byte from, byte to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ByteListIterator {
        public KeyIterator(byte k) {
            super(k);
        }

        @Override
        public byte previousByte() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(byte k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(byte k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte previous() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public byte nextByte() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Byte next() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Byte2FloatMap.Entry>
    implements Byte2FloatSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Byte2FloatMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Byte2FloatMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Byte2FloatMap.Entry> subSet(Byte2FloatMap.Entry fromElement, Byte2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2FloatMap.Entry> headSet(Byte2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Byte2FloatMap.Entry> tailSet(Byte2FloatMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte2FloatMap.Entry first() {
            if (Byte2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2FloatLinkedOpenHashMap.this.first);
        }

        @Override
        public Byte2FloatMap.Entry last() {
            if (Byte2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Byte2FloatLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            byte k = (Byte)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Byte2FloatLinkedOpenHashMap.this.mask) & Byte2FloatLinkedOpenHashMap.this.mask;
            while (Byte2FloatLinkedOpenHashMap.this.used[pos]) {
                if (Byte2FloatLinkedOpenHashMap.this.key[pos] == k) {
                    return Byte2FloatLinkedOpenHashMap.this.value[pos] == ((Float)e.getValue()).floatValue();
                }
                pos = pos + 1 & Byte2FloatLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            byte k = (Byte)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Byte2FloatLinkedOpenHashMap.this.mask) & Byte2FloatLinkedOpenHashMap.this.mask;
            while (Byte2FloatLinkedOpenHashMap.this.used[pos]) {
                if (Byte2FloatLinkedOpenHashMap.this.key[pos] == k) {
                    Byte2FloatLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Byte2FloatLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Byte2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Byte2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2FloatMap.Entry> iterator(Byte2FloatMap.Entry from) {
            return new EntryIterator((Byte)from.getKey());
        }

        public ObjectBidirectionalIterator<Byte2FloatMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Byte2FloatMap.Entry> fastIterator(Byte2FloatMap.Entry from) {
            return new FastEntryIterator((Byte)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2FloatMap.Entry> {
        final AbstractByte2FloatMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractByte2FloatMap.BasicEntry(0, 0.0f);
        }

        public FastEntryIterator(byte from) {
            super(from);
            this.entry = new AbstractByte2FloatMap.BasicEntry(0, 0.0f);
        }

        @Override
        public AbstractByte2FloatMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Byte2FloatLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2FloatLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractByte2FloatMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Byte2FloatLinkedOpenHashMap.this.key[e];
            this.entry.value = Byte2FloatLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Byte2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Byte2FloatMap.Entry> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(byte from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Byte2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = Byte2FloatLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(byte from) {
            if (Byte2FloatLinkedOpenHashMap.this.key[Byte2FloatLinkedOpenHashMap.this.last] != from) {
                int pos = HashCommon.murmurHash3(from ^ Byte2FloatLinkedOpenHashMap.this.mask) & Byte2FloatLinkedOpenHashMap.this.mask;
                while (Byte2FloatLinkedOpenHashMap.this.used[pos]) {
                    if (Byte2FloatLinkedOpenHashMap.this.key[pos] == from) {
                        this.next = (int)Byte2FloatLinkedOpenHashMap.this.link[pos];
                        this.prev = pos;
                        return;
                    }
                    pos = pos + 1 & Byte2FloatLinkedOpenHashMap.this.mask;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            this.prev = Byte2FloatLinkedOpenHashMap.this.last;
            this.index = Byte2FloatLinkedOpenHashMap.this.size;
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Byte2FloatLinkedOpenHashMap.this.size;
                return;
            }
            int pos = Byte2FloatLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)Byte2FloatLinkedOpenHashMap.this.link[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Byte2FloatLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = (int)Byte2FloatLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = (int)(Byte2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Byte2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Byte2FloatLinkedOpenHashMap.this.link[this.curr];
            }
            --Byte2FloatLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Byte2FloatLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Byte2FloatLinkedOpenHashMap.this.link[n] = Byte2FloatLinkedOpenHashMap.this.link[n] ^ (Byte2FloatLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Byte2FloatLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Byte2FloatLinkedOpenHashMap.this.link[n] = Byte2FloatLinkedOpenHashMap.this.link[n] ^ (Byte2FloatLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Byte2FloatLinkedOpenHashMap.this.mask;
                while (Byte2FloatLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Byte2FloatLinkedOpenHashMap.this.key[pos] ^ Byte2FloatLinkedOpenHashMap.this.mask) & Byte2FloatLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Byte2FloatLinkedOpenHashMap.this.mask;
                }
                if (!Byte2FloatLinkedOpenHashMap.this.used[pos]) break;
                Byte2FloatLinkedOpenHashMap.this.key[last] = Byte2FloatLinkedOpenHashMap.this.key[pos];
                Byte2FloatLinkedOpenHashMap.this.value[last] = Byte2FloatLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Byte2FloatLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Byte2FloatLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Byte2FloatMap.Entry,
    Map.Entry<Byte, Float> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Byte getKey() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public byte getByteKey() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Float getValue() {
            return Float.valueOf(Byte2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public float getFloatValue() {
            return Byte2FloatLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public float setValue(float v) {
            float oldValue = Byte2FloatLinkedOpenHashMap.this.value[this.index];
            Byte2FloatLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Float setValue(Float v) {
            return Float.valueOf(this.setValue(v.floatValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Byte2FloatLinkedOpenHashMap.this.key[this.index] == (Byte)e.getKey() && Byte2FloatLinkedOpenHashMap.this.value[this.index] == ((Float)e.getValue()).floatValue();
        }

        @Override
        public int hashCode() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.index] ^ HashCommon.float2int(Byte2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Byte2FloatLinkedOpenHashMap.this.key[this.index] + "=>" + Byte2FloatLinkedOpenHashMap.this.value[this.index];
        }
    }
}

