/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter;

import com.google.common.primitives.UnsignedInts;
import com.google.protobuf.Timestamp;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.transport.Transport;

public interface BmpAdapterTools {
    public static InetAddress address(Transport.IpAddress address) {
        switch (address.getAddressCase()) {
            case V4: {
                return InetAddressUtils.getInetAddress((byte[])address.getV4().toByteArray());
            }
            case V6: {
                return InetAddressUtils.getInetAddress((byte[])address.getV6().toByteArray());
            }
        }
        throw new IllegalStateException();
    }

    public static String addressAsStr(Transport.IpAddress address) {
        return InetAddressUtils.str((InetAddress)BmpAdapterTools.address(address));
    }

    public static Instant timestamp(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static Optional<Transport.RouteMonitoringPacket.PathAttribute> getPathAttributeOfType(Transport.RouteMonitoringPacket routeMonitoring, Transport.RouteMonitoringPacket.PathAttribute.ValueCase pathAttrValueType) {
        return routeMonitoring.getAttributesList().stream().filter(p -> Objects.equals(pathAttrValueType, p.getValueCase())).findFirst();
    }

    public static Stream<Transport.RouteMonitoringPacket.PathAttribute> getPathAttributesOfType(Transport.RouteMonitoringPacket routeMonitoring, Transport.RouteMonitoringPacket.PathAttribute.ValueCase pathAttrValueType) {
        return routeMonitoring.getAttributesList().stream().filter(p -> Objects.equals(pathAttrValueType, p.getValueCase()));
    }

    public static boolean isV4(Transport.IpAddress ipAddress) {
        return Transport.IpAddress.AddressCase.V4.equals((Object)ipAddress.getAddressCase());
    }

    public static long uint32(int i) {
        return UnsignedInts.toLong((int)i);
    }

    public static String asAttr(int val) {
        int as = val >> 16 & 0xFFFF;
        int attr = val >> 0 & 0xFFFF;
        return String.format("%d:%d", as, attr);
    }
}

