/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.bootstrap;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class BootstrapUtils {
    static String getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        try {
            Method getPid = runtime.getClass().getMethod("getPid", new Class[0]);
            if (getPid != null) {
                long pid = (Long)getPid.invoke((Object)runtime, new Object[0]);
                return String.valueOf(pid);
            }
        }
        catch (NoSuchMethodException getPid) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            System.err.println("Unable to determine PID: " + e.getLocalizedMessage());
        }
        int at = runtime.getName().indexOf("@");
        if (at > 0) {
            return runtime.getName().substring(0, at);
        }
        System.err.println("WARNING: unable to determine PID from runtime: " + runtime.getName());
        return "";
    }
}

