/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class CustomSSLTrustContextCreator {
    private static AtomicBoolean contextAlreadyCreated = new AtomicBoolean(false);
    private static SSLContext sslContext;

    public static SSLContext getTrustContext(TrustManager trustManager) throws RemoteException {
        try {
            if (contextAlreadyCreated.getAndSet(true)) {
                return sslContext;
            }
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RemoteException("Unable to find suitable algorithm while attempting to communicate with remote server.", e);
        }
        catch (KeyManagementException e) {
            throw new RemoteException("An error occurred initializing SSL context due to a problem with key management.", e);
        }
        return sslContext;
    }

    public static void setContextAlreadyCreated(boolean alreadyCreated) {
        contextAlreadyCreated.set(alreadyCreated);
    }
}

